package com.biz.crm.sfa.business.integral.rule.sdk.dto;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 积分政策dto
 * @author: rentao
 * @date: 2022/6/22 13:47
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IntegralRuleDto", description = "积分政策dto")
public class IntegralRuleDto extends TenantFlagOpDto {

  private static final long serialVersionUID = -704490297884280718L;

  /**
   * 积分规则名称
   */
  @ApiModelProperty("积分规则名称")
  private String integralRuleName;

  /**
   * 开始时间
   */
  @ApiModelProperty("生效开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("生效结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 积分规则编码
   */
  @ApiModelProperty("积分规则编码")
  private String integralRuleCode;

  /**
   * 积分规则范围
   */
  @ApiModelProperty("积分规则范围")
  private List<IntegralRuleScopeDto> integralRuleScopeDtos;

  /**
   * 积分计算规则集合
   */
  @ApiModelProperty("积分计算规则集合")
  private List<IntegralCalculateRuleDto> integralCalculateRuleDtos;

}
