package com.biz.crm.sfa.business.integral.rule.sdk.event;

import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleVo;
import java.util.List;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2022/6/22 13:53
 */
public interface IntegralRuleEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(IntegralRuleVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(IntegralRuleVo oldVo, IntegralRuleVo newVo) {
  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<IntegralRuleVo> list) {
  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<IntegralRuleVo> list) {
  }
}
