package com.biz.crm.sfa.business.integral.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 统计排名Dto
 * @author: rentao
 * @date: 2022/6/27 16:52
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IntegralCountDto", description = "统计排名Dto")
public class IntegralCountDto {

  @ApiModelProperty(name = "tenantCode", value = "租户编号")
  private String tenantCode;

  @ApiModelProperty(name = "orgCodeList", value = "组织编码集合")
  private List<String> orgCodeList;

  @ApiModelProperty(name = "createAccount", value = "创建人账号")
  private String createAccount;

  @ApiModelProperty(name = "createName", value = "创建人名称")
  private String createName;

  @ApiModelProperty("年月")
  private String integralYearMonth;

  @ApiModelProperty("范围类型")
  private String rangType;
}
