package com.biz.crm.sfa.business.integral.sdk.vo;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 积分Vo
 * @author: rentao
 * @date: 2022/6/27 10:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IntegralVo", description = "积分Vo")
public class IntegralVo  extends TenantFlagOpVo {

  private static final long serialVersionUID = -704490297884280718L;

  @ApiModelProperty("上层业务编码")
  private String parentCode;

  @ApiModelProperty("表单编码")
  private String dynamicFormCode;

  @ApiModelProperty("步骤编码")
  private String dynamicKey;

  @ApiModelProperty("积分规则编码")
  private String integralRuleCode;

  @ApiModelProperty("积分规则id")
  private String integralRuleId;

  @ApiModelProperty("积分规则名称")
  private String integralRuleName;

  @ApiModelProperty("积分数")
  private Integer integralNum;

  @ApiModelProperty("积分任务类型编码")
  private String integralTaskTypeCode;

  @ApiModelProperty("积分任务类型名称")
  private String integralTaskTypeName;

  @ApiModelProperty("创建人岗位名称")
  private String createPosName;

  @ApiModelProperty("创建人岗位")
  private String createPosCode;

  @ApiModelProperty("创建人组织")
  private String createOrgCode;

  @ApiModelProperty("创建人组织名称")
  private String createOrgName;

  @ApiModelProperty("职位级别编码")
  private String createPositionLevelCode;

  @ApiModelProperty("职位级别编码")
  private String createPositionLevelName;

  @ApiModelProperty("年月")
  private String integralYearMonth;


}
