package com.biz.crm.sfa.leave.local.dto;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.util.List;

/**
 * 考勤管理-各种申请-日期明细 请求vo
 *
 * @author ren.gang
 * @date 2020-11-20 15:00:38
 */
@Data
@ApiModel(value = "SfaApplyTimeInfoDto", description = "考勤管理-日期明细（申请）Dto")
public class SfaApplyTimeInfoDto {

    @ApiModelProperty("日期")
    private String timeStr;

    @ApiModelProperty("日期类型(1全天，2上午，3下午)")
    private String timeType;

    public SfaApplyTimeInfoDto(){}
    public SfaApplyTimeInfoDto(String timeStr, String timeType) {
        this.timeStr = timeStr;
        this.timeType = timeType;
    }

    /**
     * 获取本对象列表中指定日期数据的 日期类型
     * @param json
     * @param date
     * @return
     */
    public static String getTypeByDate(String json, String date) {
        if(StringUtils.isEmpty(json)) {
            return null;
        }
        List<SfaApplyTimeInfoDto> SfaApplyTimeInfoDtos = JSON.parseArray(json, SfaApplyTimeInfoDto.class);
        //获取请假或者销假的明细——为了获取开始请假时间和结束请假时间
        SfaApplyTimeInfoDto leaveStartTimeInfoReqVo = SfaApplyTimeInfoDtos.get(0);
        SfaApplyTimeInfoDto leaveEndTimeInfoReqVo = SfaApplyTimeInfoDtos.get(SfaApplyTimeInfoDtos.size()-1);
        int start = LocalDate.parse(leaveStartTimeInfoReqVo.getTimeStr()).compareTo(LocalDate.parse(date));
        int end = LocalDate.parse(leaveEndTimeInfoReqVo.getTimeStr()).compareTo(LocalDate.parse(date));
        //判断 当前时间是否在 请假或者销假 的开始和结束时间之中
        if(start<=0&&end>=0){
            //如果正好与开始时间相等，返回 请假或者销假 开始时间的日期类型
            if (start==0){
                return leaveStartTimeInfoReqVo.getTimeType();
            }
            //如果正好与结束时间相等，返回 请假或者销假 结束时间的日期类型
            if (end == 0 ){
                return leaveEndTimeInfoReqVo.getTimeType();
            }
            //默认返回全天的日期类型————ps:不与开始和结束的时间相等时，因为 请假或者销假 的时间必定连续，所需直接返回全天的日期类型（“1”）
            return "1";
        }
        return null;
    }

}