package com.biz.crm.sfa.leave.local.dto;

import com.biz.crm.business.common.sdk.dto.WorkflowFlagOpDto;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveAttachmentEntity;
import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import java.util.List;
import java.util.Set;

/**
 * 请假申请 请求vo
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaLeaveDto", description = "请假申请 ")
public class SfaLeaveDto extends WorkflowFlagOpDto {

    @ApiModelProperty(value = "请假类型 请假类型", required = true)
    private String leaveType;

    @ApiModelProperty("请假事由 请假事由")
    private String leaveReason;

    @ApiModelProperty("人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员姓名 人员姓名")
    private String realName;

    @ApiModelProperty("职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    private String posName;

    /**
     * 上级组织编码
     */
    @ApiModelProperty("上级组织编码")
    private String parentOrgCode;

    /**
     * 上级组织名称
     */
    @ApiModelProperty("上级组织名称")
    private String parentOrgName;

    /**
     * 父级职位编码
     */
    @ApiModelProperty("父级职位编码")
    private String parentPosCode;

    @ApiModelProperty("所属组织编码 所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织名称 所属组织名称")
    private String orgName;

    @ApiModelProperty(value = "开始时间 开始时间(yyyy-MM-dd)", required = true)
    private String beginTime;

    @ApiModelProperty(value = "结束时间 结束时间(yyyy-MM-dd)", required = true
    )
    private String endTime;

    @ApiModelProperty("审批状态 审批状态")
    private String processStatus;

    @ApiModelProperty(value = "日期明细列表", required = true)
    private List<SfaApplyTimeInfoDto> timeInfoList;

    @ApiModelProperty("请假时长(天)")
    private String leaveDuration;

    @ApiModelProperty("附件集合")
    private List<SfaLeaveAttachmentEntity> attachmentList;

    @ApiModelProperty("流程附件")
    private List<AttachmentVo> attachmentVos;

    @ApiModelProperty("用户名列表")
    private Set<String> userNames;

}