package com.biz.crm.sfa.leave.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 调休 实体类
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_days_off")
@Table(name = "sfa_days_off")
@ApiModel(value = "sfaLeave", description = "调休表")
@org.hibernate.annotations.Table(appliesTo = "sfa_days_off", comment = "调休表")
public class SfaDaysOffEntity extends WorkflowFlagOpEntity {

  /**
   * 调休原由
   */
  @Column(name = "days_off_reason", length = 512, columnDefinition = "varchar(512) COMMENT '调休原由'")
  @ApiModelProperty("调休原由")
  private String daysOffReason;

  /**
   * 人员账号 人员账号
   */
  @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '人员账号 人员账号'")
  @ApiModelProperty("人员账号")
  private String userName;

  /**
   * 人员姓名 人员姓名
   */
  @Column(name = "real_name", length = 100, columnDefinition = "varchar(32) COMMENT '人员姓名 人员姓名'")
  @ApiModelProperty("人员姓名")
  private String realName;

  /**
   * 职位编码 职位编码
   */
  @Column(name = "pos_code", length = 32, columnDefinition = "varchar(32) COMMENT '职位编码 职位编码'")
  @ApiModelProperty("职位编码")
  private String posCode;

  /**
   * 全部调休天数
   */
  @Column(name = "all_days",  columnDefinition = "decimal(10,2) COMMENT '全部调休天数'")
  @ApiModelProperty("全部调休天数")
  private BigDecimal allDays;

  /**
   * 已调休天数
   */
  @Column(name = "used_days", columnDefinition = "decimal(10,2) COMMENT '已调休天数'")
  @ApiModelProperty("已调休天数")
  private BigDecimal usedDays;

  /**
   * 可用调休天数
   */
  @Column(name = "available_days", columnDefinition = "decimal(10,2) COMMENT '可用调休天数'")
  @ApiModelProperty("可用调休天数")
  private BigDecimal availableDays;

  /**
   * 节假日天数
   */
  @ApiModelProperty("节假日天数")
  @Column(name = "holiday_days", columnDefinition = "decimal(10,2) COMMENT '节假日天数'")
  private BigDecimal holidayDays;


}
