package com.biz.crm.sfa.leave.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 请假申请 实体类
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_leave")
@Table(name = "sfa_leave")
@ApiModel(value = "sfaLeave", description = "请假申请表")
@org.hibernate.annotations.Table(appliesTo = "sfa_leave", comment = "请假申请表")
public class SfaLeaveEntity extends WorkflowFlagOpEntity {

  /**
   * 请假类型 请假类型
   */
  @Column(name = "leave_type", length = 32, columnDefinition = "varchar(32) COMMENT '请假类型 请假类型'")
  @ApiModelProperty("请假类型")
  private String leaveType;

  /**
   * 请假事由 请假事由
   */
  @Column(name = "leave_reason", length = 512, columnDefinition = "varchar(512) COMMENT '请假事由 请假事由'")
  @ApiModelProperty("请假事由")
  private String leaveReason;

  /**
   * 人员账号 人员账号
   */
  @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '人员账号 人员账号'")
  @ApiModelProperty("人员账号")
  private String userName;

  /**
   * 人员姓名 人员姓名
   */
  @Column(name = "real_name", length = 100, columnDefinition = "varchar(32) COMMENT '人员姓名 人员姓名'")
  @ApiModelProperty("人员姓名")
  private String realName;

  /**
   * 职位编码 职位编码
   */
  @Column(name = "pos_code", length = 32, columnDefinition = "varchar(32) COMMENT '职位编码 职位编码'")
  @ApiModelProperty("职位编码")
  private String posCode;

  /**
   * 父级职位编码
   */
  @Column(name = "parent_pos_code", length = 32, columnDefinition = "varchar(32) COMMENT '父级职位编码'")
  @ApiModelProperty("父级职位编码")
  private String parentPosCode;

  /**
   * 职位名称 职位名称
   */
  @Column(name = "pos_name", length = 100, columnDefinition = "varchar(100) COMMENT '职位名称 职位名称'")
  @ApiModelProperty("职位名称")
  private String posName;

  /**
   * 所属组织编码 所属组织编码
   */
  @Column(name = "org_code", length = 32, columnDefinition = "varchar(32) COMMENT '所属组织编码 所属组织编码'")
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 所属组织名称 所属组织名称
   */
  @Column(name = "org_name", length = 100, columnDefinition = "varchar(100) COMMENT '所属组织名称 所属组织名称'")
  @ApiModelProperty("所属组织名称")
  private String orgName;

  /**
   * 上级组织编码
   */
  @Column(name = "parent_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级组织编码'")
  @ApiModelProperty("上级组织编码")
  private String parentOrgCode;

  /**
   * 上级组织名称
   */
  @Column(name = "parent_org_name", length = 64, columnDefinition = "varchar(64) COMMENT '上级组织名称'")
  @ApiModelProperty("上级组织名称")
  private String parentOrgName;

  /**
   * 申请日期 申请日期(yyyy-MM-dd HH:mm:dd)
   */
  @Column(name = "application_date", length = 32, columnDefinition = "varchar(32) COMMENT '申请日期 申请日期(yyyy-MM-dd HH:mm:dd)'")
  @ApiModelProperty("申请日期(yyyy-MM-dd HH:mm:dd)")
  private String applicationDate;

  /**
   * 开始时间 开始时间(yyyy-MM-dd HH)
   */
  @Column(name = "begin_time", length = 32, columnDefinition = "varchar(32) COMMENT '开始时间 开始时间(yyyy-MM-dd HH)'")
  @ApiModelProperty("开始时间(yyyy-MM-dd HH:mm:dd)")
  private String beginTime;

  /**
   * 结束时间 结束时间(yyyy-MM-dd HH)
   */
  @Column(name = "end_time", length = 32, columnDefinition = "varchar(32) COMMENT '结束时间 结束时间(yyyy-MM-dd HH)'")
  @ApiModelProperty("结束时间(yyyy-MM-dd HH:mm:dd)")
  private String endTime;

  /**
   * 日期明细json
   */
  @Column(name = "time_info_list_json", length = 512, columnDefinition = "varchar(512) COMMENT '日期明细json'")
  @ApiModelProperty("日期明细json")
  private String timeInfoListJson;

  /**
   * 请假时长(天)
   */
  @Column(name = "leave_duration", length = 512, columnDefinition = "varchar(512) COMMENT '请假时长(天)'")
  @ApiModelProperty("请假时长")
  private String leaveDuration;

  /**
   * 非工作日
   */
  @Column(name = "non_work_date_list_json", length = 512, columnDefinition = "varchar(32) COMMENT '非工作日'")
  @ApiModelProperty("非工作日")
  private String nonWorkDateListJson;

  /**
   * 审批通过时间
   */
  @Column(name = "pass_status_date", length = 32, columnDefinition = "varchar(32) COMMENT '审批通过时间'")
  @ApiModelProperty("审批通过时间")
  private String passStatusDate;

  /**
   * 已抵扣天数
   */
  @Column(name = "use_days",  columnDefinition = "decimal(10,2) COMMENT '已抵扣天数'")
  @ApiModelProperty("已抵扣天数")
  private BigDecimal useDays;

  /**
   * 剩余抵扣天数
   */
  @Column(name = "last_days", columnDefinition = "decimal(10,2) COMMENT '剩余抵扣天数'")
  @ApiModelProperty("剩余抵扣天数")
  private BigDecimal lastDays;

  /**
   * 使用抵扣的id集合
   */
  @Column(name = "use_deduction_ids", length = 500, columnDefinition = "varchar(500) COMMENT '使用抵扣的id集合'")
  @ApiModelProperty("使用抵扣的id集合")
  private String useDeductionIds;

}
