package com.biz.crm.sfa.leave.local.observer;

import com.biz.crm.sfa.business.leave.sdk.constant.SfaLeaveConstant;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveTypeEnum;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;
import com.biz.crm.sfa.leave.local.repository.SfaLeaveRepository;
import com.biz.crm.sfa.leave.local.service.SfaLeaveService;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 *
 */
@Component
public class SfaLeaverListener implements CallBackListener {

  @Autowired
  private SfaLeaveRepository sfaLeaveRepository;

  @Autowired
  private SfaLeaveService sfaLeaveService;

  @Override
  public void onCallBack(CallBackDto dto) {
    //校验流程业务来源，非本业务来源不进行处理
    if (!dto.getFormType().equals(SfaLeaveConstant.SFA_LEAVE_PROCESS_NAME)) {
      return;
    }
    //校验单号
    SfaLeaveEntity sfaLeaveEntity = this.sfaLeaveRepository.findByProcessNumber(dto.getProcessNo());
    if (ObjectUtils.isEmpty(sfaLeaveEntity)) {
      return;
    }
    //校验审批状态
    Validate.isTrue(sfaLeaveEntity.getProcessStatus().equals(ActApproveStatusEnum.APPROVING.getCode()), "此订单非审批中状态，无法进行操作！");
    sfaLeaveEntity.setProcessStatus(String.valueOf(dto.getProcessState()));
    if (LeaveTypeEnum.DAYS_OFF.getDictCode().equals(sfaLeaveEntity.getLeaveType()) && !String.valueOf(dto.getProcessState()).equals(ActApproveStatusEnum.APPROVED.getCode())) {
      //非审批通过调休请假时，回退调休占用
      this.sfaLeaveService.updateDaysOff(sfaLeaveEntity,false);
    }
    this.sfaLeaveRepository.updateById(sfaLeaveEntity);
  }
}
