package com.biz.crm.sfa.leave.local.repository;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveAttachmentEntity;
import com.biz.crm.sfa.leave.local.mapper.SfaLeaveAttachmentMapper;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 请假申请附件数据访问层
 *
 * @author jerry7
 * @since 2022-05-06 11:15:39
 */
@Component
public class SfaLeaveAttachmentRepository extends ServiceImpl<SfaLeaveAttachmentMapper, SfaLeaveAttachmentEntity> {

  /**
   * 根据SourceId查询请假申请附件列表
   *
   * @param sourceId 请假来源ID
   * @return 请假申请附件列表
   */
  public List<SfaLeaveAttachmentEntity> findBySourceId(String sourceId) {
    return this.baseMapper.selectList(Wrappers.lambdaQuery(SfaLeaveAttachmentEntity.class).eq(SfaLeaveAttachmentEntity::getSourceId, sourceId));
  }

  /**
   * 根据请假id删除附件列表
   * @param sourceId 请假id
   */
  public void deleteBySourceId(String sourceId) {
    this.lambdaUpdate().eq(SfaLeaveAttachmentEntity::getSourceId, sourceId)
            .remove();
  }

}


