package com.biz.crm.sfa.leave.local.service;

import com.biz.crm.sfa.leave.local.dto.SfaLeaveDto;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;

import java.math.BigDecimal;


/**
 * 请假接口
 */
public interface SfaLeaveService {

  /**
   * 请假申请接口
   *
   * @param SfaLeaveDto
   * @return
   */
  SfaLeaveEntity create(SfaLeaveDto SfaLeaveDto);

  /**
   * 计算请假时长
   *
   * @param reqVo
   * @return
   */
  BigDecimal countApplyDays(SfaLeaveDto reqVo);

  /**
   * 追回请假申请
   *
   * @param id
   * @return
   */
  void rollbackLeave(String id);

  /**
   * 追加附件信息
   *
   * @param SfaLeaveDto
   * @return
   */
  void addAttachment(SfaLeaveDto SfaLeaveDto);

  /**
   * 更新调休占用
   * @param entity 请假实体
   * @param deduction 是否抵扣
   */
  void updateDaysOff(SfaLeaveEntity entity, boolean deduction);
}

