package com.biz.crm.sfa.leave.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.overtime.sdk.event.OvertimeApplyEventListener;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.biz.crm.sfa.leave.local.entity.SfaDaysOffEntity;
import com.biz.crm.sfa.leave.local.repository.SfaDaysOffRepository;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * 加班申请通过后，更新调休信息
 */
@Component
public class OvertimeEventListener implements OvertimeApplyEventListener {

  @Autowired
  private SfaDaysOffRepository sfaDaysOffRepository;

  @Autowired
  private LoginUserService loginUserService;

  @Override
  public void onApproved(OvertimeApplyVo vo) {
    if (ObjectUtils.isEmpty(vo) || StringUtils.isBlank(vo.getUserName())) {
      return;
    }
    SfaDaysOffEntity sfaDaysOffEntity = this.sfaDaysOffRepository.findByUserName(vo.getUserName());
    LoginUserDetails loginUserDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    if (ObjectUtils.isEmpty(sfaDaysOffEntity)) {
      //为空则新建调休实体
      sfaDaysOffEntity = new SfaDaysOffEntity();
      sfaDaysOffEntity.setUserName(vo.getUserName());
      sfaDaysOffEntity.setRealName(vo.getUserRealName());
      sfaDaysOffEntity.setAllDays(vo.getApplyDuration());
      sfaDaysOffEntity.setUsedDays(BigDecimal.ZERO);
      sfaDaysOffEntity.setAvailableDays(vo.getApplyDuration());
      sfaDaysOffEntity.setHolidayDays(vo.getHolidayDays());
      sfaDaysOffEntity.setTenantCode(loginUserDetails.getTenantCode());
      this.sfaDaysOffRepository.save(sfaDaysOffEntity);
    } else {
      sfaDaysOffEntity.setAllDays(sfaDaysOffEntity.getAllDays().add(vo.getApplyDuration()));
      sfaDaysOffEntity.setAvailableDays(sfaDaysOffEntity.getAvailableDays().add(vo.getApplyDuration()));
      sfaDaysOffEntity.setHolidayDays(sfaDaysOffEntity.getHolidayDays().add(vo.getHolidayDays()));
      this.sfaDaysOffRepository.updateById(sfaDaysOffEntity);
    }

  }
}
