package com.biz.crm.sfa.leave.local.vo;

import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveAttachmentEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 请假申请 返回vo
 *
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "请假申请 ")
public class SfaLeaveVo extends WorkflowFlagOpVo {

  /**
   * 请假类型
   */
  @ApiModelProperty("请假类型")
  private String leaveType;

  /**
   * 请假类型名称
   */
  @ApiModelProperty("请假类型名称")
  private String leaveTypeName;

  /**
   * 请假事由
   */
  @ApiModelProperty("请假事由 请假事由")
  private String leaveReason;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号 人员账号")
  private String userName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名 人员姓名")
  private String realName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码 职位编码")
  private String posCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称 职位名称")
  private String posName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码 所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("所属组织名称 所属组织名称")
  private String orgName;

  /**
   * 申请日期(yyyy-MM-dd HH:mm:dd)
   */
  @ApiModelProperty("申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
  private String applicationDate;

  /**
   * 开始时间(yyyy-MM-dd HH)
   */
  @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd HH)")
  private String beginTime;

  /**
   * 结束时间(yyyy-MM-dd HH)
   */
  @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd HH)")
  private String endTime;

  /**
   * 审批状态名称
   */
  @ApiModelProperty("审批状态名称")
  private String bpmStatusName;

  /**
   * 日期明细json
   */
  @ApiModelProperty("日期明细json")
  private String timeInfoListJson;

  /**
   * 请假时长(天)
   */
  @ApiModelProperty("请假时长(天)")
  private String leaveDuration;

  /**
   * 附件列表json
   */
  @ApiModelProperty("附件列表")
  private List<SfaLeaveAttachmentEntity> attachmentList;

  /**
   * 销假天数
   */
  @ApiModelProperty("销假天数")
  private String cancelDays;

  /**
   * 非工作日
   */
  @ApiModelProperty("非工作日")
  private String nonWorkDateListJson;

}