package com.biz.crm.sfa.leave.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.leave.local.dto.SfaLeaveDto;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;
import com.biz.crm.sfa.leave.local.service.SfaLeaveService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;


/**
 * 请假接口
 *
 * @author jerry7
 */
@Slf4j
@RestController
@RequestMapping("v1/sfa/leave")
@Api(tags = "请假:leave:请假申请 ")
public class SfaLeaveController {
  @Autowired
  private SfaLeaveService iSfaLeaveService;

  @ApiOperation(value = "请假-申请")
  @PostMapping("/create")
  public Result<SfaLeaveEntity> create(@RequestBody SfaLeaveDto sfaLeaveDto) {
    return Result.ok(iSfaLeaveService.create(sfaLeaveDto));
  }

  @ApiOperation(value = "请假-计算时长")
  @PostMapping("/countApplyDays")
  public Result<BigDecimal> countApplyDays(@RequestBody SfaLeaveDto reqVo) {
    return Result.ok(iSfaLeaveService.countApplyDays(reqVo));
  }

  @ApiOperation(value = "请假-追加附件信息")
  @PostMapping("/addAttachment")
  public Result<?> addAttachmentLeave(@RequestBody SfaLeaveDto SfaLeaveDto) {
    this.iSfaLeaveService.addAttachment(SfaLeaveDto);
    return Result.ok();
  }
}
