package com.biz.crm.sfa.leave.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveApplySummaryDto;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveVisibleEnum;
import com.biz.crm.sfa.business.leave.sdk.service.SfaLeaveVoService;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveApplySummaryVo;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;


/**
 * 请假接口
 *
 * @author jerry7
 */
@Slf4j
@RestController
@RequestMapping("v1/sfa/leaveVo")
@Api(tags = "请假:leaveVo:请假查询 ")
public class SfaLeaveVoController {
  @Autowired
  private SfaLeaveVoService sfaLeaveVoService;

  @Autowired
  private LoginUserService loginUserService;

  @ApiOperation(value = "请假-列表查询(我的提交的)")
  @GetMapping("/findSfaLeaveBpmList")
  public Result<Page<SfaLeaveVo>> findSfaLeaveBpmList(@PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "sfaLeaveListDto", value = "分页Dto") SfaLeaveListDto dto) {
    Page<SfaLeaveVo> result = new Page<>();
    //检查可见范围
    if (StringUtils.isBlank(dto.getVisibleScope())) {
      dto.setVisibleScope(LeaveVisibleEnum.all.getDictCode());
    }
    //获取当前登录人信息
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    if (ObjectUtils.isNotEmpty(loginDetails) && StringUtils.isNotEmpty(loginDetails.getUsername())) {
      //设置职位编码和用户名
      dto.setPostCode(loginDetails.getPostCode());
      dto.setUserName(loginDetails.getAccount());
      result = sfaLeaveVoService.findByConditions(pageable, dto);
    }
    return Result.ok(result);
  }

  @ApiOperation(value = "请假-详情")
  @GetMapping("/findSfaLeaveById")
  public Result<SfaLeaveVo> findSfaLeaveById(@RequestParam("id") String id) {
    Validate.notNull(id, "id不能为空");
    return Result.ok(this.sfaLeaveVoService.queryById(id));
  }

  @ApiOperation(value = "通过流程业务编码获取请假详情")
  @GetMapping("/findByBusinessNo")
  public Result<SfaLeaveVo> findByBusinessNo(@RequestParam("businessNo") String businessNo) {
    return Result.ok(this.sfaLeaveVoService.queryById(businessNo));
  }

  @ApiOperation(value = "请假汇总列表分页查询")
  @GetMapping("/findLeaveSummaryByConditions")
  public Result<Page<SfaLeaveApplySummaryVo>> findLeaveSummaryByConditions(@PageableDefault(50) Pageable pageable,
                                                                           @ApiParam(name = "sfaLeaveApplySummaryDto", value = "分页Dto") SfaLeaveApplySummaryDto dto) {
    return Result.ok(this.sfaLeaveVoService.findSummaryByConditions(pageable, dto));
  }

  @ApiOperation(value = "请假明细报表")
  @GetMapping("/findDetailsByConditions")
  public Result<Page<SfaLeaveVo>> findDetailsByConditions(@PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "sfaLeaveListDto", value = "分页Dto") SfaLeaveListDto dto) {
    return Result.ok(this.sfaLeaveVoService.findByConditions(pageable, dto));
  }
}
