package com.biz.crm.sfa.leave.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;

import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 考勤相关附件实体类
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_leave_attachment")
@ApiModel(value = "sfa_leave_attachment", description = "考勤相关申请附件信息")
@Table(name = "sfa_leave_attachment")
@org.hibernate.annotations.Table(appliesTo = "sfa_leave_attachment", comment = "考勤相关申请附件信息")
public class SfaLeaveAttachmentEntity extends FileEntity {

    /**
     * 申请类型（leave-请假，exception-异常报备）
     */
    @Column(name = "apply_type", length = 64, columnDefinition = "varchar(64) COMMENT '申请类型（leave-请假，exception-异常报备）'")
    @ApiModelProperty("申请类型（leave-请假，exception-异常报备）")
    private String applyType;

    /**
     * 来源id
     */
    @Column(name = "source_id", length = 64, columnDefinition = "varchar(64) COMMENT '来源id'")
    @ApiModelProperty("来源ID")
    private String sourceId;

}
