package com.biz.crm.sfa.leave.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.leave.local.dto.SfaLeaveDto;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 请假申请mapper
 *
 * @author jerry7
 */
public interface SfaLeaveMapper extends BaseMapper<SfaLeaveEntity> {

  /**
   * 列表
   *
   * @param SfaLeaveDto 查询参数
   * @return 请假申请列表
   */
  List<SfaLeaveEntity> findByConditions(@Param("vo") SfaLeaveListDto SfaLeaveDto);

  /**
   * 查询日期冲突数据
   * 1、非拒绝状态
   * 2、原开始时间 <= 结束时间 and 原结束时间 >= 开始时间
   *
   * @param userName  用户账号
   * @param beginTime 开始时间
   * @param endTime   结束时间
   * @param id        排除的id
   * @return 请假数据
   */
  List<SfaLeaveEntity> findRepeatByDates(@Param("userName") String userName, @Param("beginTime") String beginTime
      , @Param("endTime") String endTime, @Param("id") String id);


  List<SfaLeaveEntity> findDetails(@Param("vo") SfaLeaveDto sfaLeaveDto);
}
