package com.biz.crm.sfa.leave.local.observer;

import com.biz.crm.sfa.business.leave.sdk.constant.SfaLeaveConstant;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveTypeEnum;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;
import com.biz.crm.sfa.leave.local.repository.SfaLeaveRepository;
import com.biz.crm.sfa.leave.local.service.SfaLeaveService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 请假申请审批回调类
 *
 * @author ning.zhang
 * @date 2022/8/31
 */
@Component
public class SfaLeaverProcessCompleteListener implements ProcessCompleteListener {

  @Autowired
  private SfaLeaveRepository sfaLeaveRepository;

  @Autowired
  private SfaLeaveService sfaLeaveService;

  @Override
  public String getBusinessCode() {
    return SfaLeaveConstant.SFA_LEAVE_PROCESS_FROM_TYPE;
  }

  @Override
  @Transactional
  public void onProcessComplete(ProcessStatusDto dto) {
    //校验流程业务来源，非本业务来源不进行处理
    if (!dto.getBusinessCode().equals(SfaLeaveConstant.SFA_LEAVE_PROCESS_FROM_TYPE)) {
      return;
    }
    //校验单号
    SfaLeaveEntity sfaLeaveEntity = this.sfaLeaveRepository.getById(dto.getBusinessNo());
    Validate.notNull(sfaLeaveEntity, "请假申请记录不存在！");
    if (LeaveTypeEnum.DAYS_OFF.getDictCode().equals(sfaLeaveEntity.getLeaveType()) && !ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())) {
      //非审批通过调休请假时，回退调休占用
      this.sfaLeaveService.updateDaysOff(sfaLeaveEntity, false);
    }
  }
}
