package com.biz.crm.sfa.leave.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.leave.local.entity.SfaDaysOffEntity;
import com.biz.crm.sfa.leave.local.mapper.SfaDaysOffMapper;
import org.springframework.stereotype.Component;



/**
 * 调休数据数据访问层
 *
 * @author jerry7
 * @since 2022-05-06 11:15:39
 */
@Component
public class SfaDaysOffRepository extends ServiceImpl<SfaDaysOffMapper, SfaDaysOffEntity> {

  /**
   * 根据用户名查询调休数据
   *
   * @param userName 用户名
   * @return 调休数据
   */
  public SfaDaysOffEntity findByUserName(String userName) {
    return this.lambdaQuery().eq(SfaDaysOffEntity::getUserName, userName)
            .one();
  }

}

