package com.biz.crm.sfa.leave.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.leave.local.dto.SfaLeaveDto;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;
import com.biz.crm.sfa.leave.local.mapper.SfaLeaveMapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 请假申请数据访问层
 *
 * @author jerry7
 * @since 2022-05-06 11:15:39
 */
@Component
public class SfaLeaveRepository extends ServiceImpl<SfaLeaveMapper, SfaLeaveEntity> {

  /**
   * 集合数据
   *
   * @param sfaLeaveDto 请求参数
   * @return 请假数据
   */
  public List<SfaLeaveEntity> findByConditions(@Param("vo") SfaLeaveListDto sfaLeaveDto) {
    return this.baseMapper.findByConditions(sfaLeaveDto);
  }

  /**
   * 列表
   *
   * @param sfaLeaveDto 分页请求
   * @return 请假数据
   */
  public List<SfaLeaveEntity> findDetails(@Param("vo") SfaLeaveDto sfaLeaveDto) {
    return this.baseMapper.findDetails(sfaLeaveDto);
  }

  /**
   * 查询日期冲突数据
   * 1、非拒绝状态
   * 2、原开始时间 <= 结束时间 and 原结束时间 >= 开始时间
   *
   * @param userName  用户账号
   * @param beginTime 开始时间
   * @param endTime   结束时间
   * @param id        排除的id
   * @return 重复请假数据
   */
  public List<SfaLeaveEntity> findRepeatByDates(String userName, String beginTime, String endTime, String id) {
    return this.baseMapper.findRepeatByDates(userName, beginTime, endTime, id);
  }
}

