package com.biz.crm.sfa.leave.local.utils;


import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * json 工具类
 */
@Slf4j
public class JsonPropertyUtil {
    /**
     * json 转对象
     * @param content
     * @param valueType
     * @param <T>
     * @return
     */
    public static <T> T toObject(String content, Class<T> valueType) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES,true);
            objectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            return objectMapper.readValue(content, valueType);
        }catch (Exception e){
            log.error("json处理异常",e);
        }
        return null;
    }

    /**
     * 转列表
     *
     * @param json
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> List<T> toArray(String json, Class<T> clazz) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            JavaType type = objectMapper.getTypeFactory().constructParametricType(List.class, clazz);
            return objectMapper.readValue(json, type);
        } catch (Exception e) {
            log.error("json处理异常",e);
        }
        return null;
    }

    /**
     * 转json， sap用
     * ################## 慎用 ###################
     *######################## 该方法序列化出来的json有可能无法反序列 ############################
     * @param object
     * @return
     */
    @Deprecated
    public static String toJsonString(Object object) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);//数字转string
            objectMapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true); //数字转string
            objectMapper.getSerializerProvider().setNullValueSerializer(new JsonSerializer<Object>() {//null值转空字符串

                @Override
                public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                    if (value == null) {
                        /**
                         * ######################## 此操作会导致null数组对象 无法反序列 ############################
                         */
                        gen.writeString("");
                    }
                }
            });
            return objectMapper.writeValueAsString(object);
        } catch (Exception e) {
            log.error("json处理异常",e);
        }
        return "";
    }

    /**
     * 转json， 不处理空对象
     *
     * @param object
     * @return
     */
    public static String toJsonStringNotEmptyVal(Object object) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);//数字转string
            objectMapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true); //数字转string
            return objectMapper.writeValueAsString(object);
        } catch (Exception e) {
            log.error("json处理异常",e);
        }
        return "";
    }

    public static <T> T toObject(Map<String, Object> map, Class<T> valueType) {
        try {
            map = map==null?new HashMap<>():map;
            String content = JSON.toJSONString(map);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES,true);
            objectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            return objectMapper.readValue(content, valueType);
        }catch (Exception e){
            log.error("json处理异常",e);
        }
        return null;
    }

}
