package com.biz.crm.sfa.leave.local.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName SfaLeaveApplyDetailRespVo.java
 * @Description 请假申请明细返回Vo
 * @createTime 2020年12月01日 13:22:00
 */
@Data
@ApiModel("请假申请明细返回Vo")
public class SfaLeaveApplyDetailVo extends TenantFlagOpVo {

    private String id;

    @ApiModelProperty("请假类型 请假类型")
    private String leaveType;

    @ApiModelProperty("请假类型名称")
    private String leaveTypeName;

    @ApiModelProperty("请假事由 请假事由")
    private String leaveReason;

    @ApiModelProperty("人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员姓名 人员姓名")
    private String realName;

    @ApiModelProperty("职位名称 职位名称")
    private String posName;

    @ApiModelProperty("区域")
    private String parentOrgName;

    @ApiModelProperty("办事处")
    private String orgName;

    @ApiModelProperty("申请日期 申请日期(yyyy-MM-dd)")
    private String applicationDate;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd)")
    private String endTime;

    @ApiModelProperty("审批状态 审批状态")
    private String processStatus;

    @ApiModelProperty("审批状态名称")
    private String bpmStatusName;

    @ApiModelProperty("日期明细json")
    private String timeInfoListJson;

    @ApiModelProperty("请假时长(天)")
    private String leaveDuration;

    @ApiModelProperty("附件列表json")
    private String attachmentListJson;

    @ApiModelProperty("销假天数")
    private String cancelDays;

    @ApiModelProperty("审核任务id")
    private String auditTaskId;

    @ApiModelProperty("非工作日日期明细列表")
    private String nonWorkDateListJson;

}
