/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.leave.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveApplySummaryDto;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveVisibleEnum;
import com.biz.crm.sfa.business.leave.sdk.service.SfaLeaveVoService;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveApplySummaryVo;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"v1/sfa/leaveVo"})
@Api(tags={"\u8bf7\u5047:leaveVo:\u8bf7\u5047\u67e5\u8be2 "})
public class SfaLeaveVoController {
    private static final Logger log = LoggerFactory.getLogger(SfaLeaveVoController.class);
    @Autowired
    private SfaLeaveVoService sfaLeaveVoService;
    @Autowired
    private LoginUserService loginUserService;

    @ApiOperation(value="\u8bf7\u5047-\u5217\u8868\u67e5\u8be2(\u6211\u7684\u63d0\u4ea4\u7684)")
    @GetMapping(value={"/findSfaLeaveBpmList"})
    public Result<Page<SfaLeaveVo>> findSfaLeaveBpmList(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="sfaLeaveListDto", value="\u5206\u9875Dto") SfaLeaveListDto dto) {
        FacturerUserDetails loginDetails;
        Page result = new Page();
        if (StringUtils.isBlank((CharSequence)dto.getVisibleScope())) {
            dto.setVisibleScope(LeaveVisibleEnum.all.getDictCode());
        }
        if (ObjectUtils.isNotEmpty((Object)(loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class))) && StringUtils.isNotEmpty((CharSequence)loginDetails.getUsername())) {
            dto.setPostCode(loginDetails.getPostCode());
            dto.setUserName(loginDetails.getAccount());
            result = this.sfaLeaveVoService.findByConditions(pageable, dto);
        }
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u8bf7\u5047-\u8be6\u60c5")
    @GetMapping(value={"/findSfaLeaveById"})
    public Result<SfaLeaveVo> findSfaLeaveById(@RequestParam(value="id") String id) {
        Validate.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return Result.ok((Object)this.sfaLeaveVoService.queryById(id));
    }

    @ApiOperation(value="\u901a\u8fc7\u6d41\u7a0b\u4e1a\u52a1\u7f16\u7801\u83b7\u53d6\u8bf7\u5047\u8be6\u60c5")
    @GetMapping(value={"/findByBusinessNo"})
    public Result<SfaLeaveVo> findByBusinessNo(@RequestParam(value="businessNo") String businessNo) {
        return Result.ok((Object)this.sfaLeaveVoService.queryById(businessNo));
    }

    @ApiOperation(value="\u8bf7\u5047\u6c47\u603b\u5217\u8868\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findLeaveSummaryByConditions"})
    public Result<Page<SfaLeaveApplySummaryVo>> findLeaveSummaryByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="sfaLeaveApplySummaryDto", value="\u5206\u9875Dto") SfaLeaveApplySummaryDto dto) {
        return Result.ok((Object)this.sfaLeaveVoService.findSummaryByConditions(pageable, dto));
    }

    @ApiOperation(value="\u8bf7\u5047\u660e\u7ec6\u62a5\u8868")
    @GetMapping(value={"/findDetailsByConditions"})
    public Result<Page<SfaLeaveVo>> findDetailsByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="sfaLeaveListDto", value="\u5206\u9875Dto") SfaLeaveListDto dto) {
        return Result.ok((Object)this.sfaLeaveVoService.findByConditions(pageable, dto));
    }
}

