/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.leave.local.observer;

import com.biz.crm.sfa.business.leave.sdk.enums.LeaveTypeEnum;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;
import com.biz.crm.sfa.leave.local.repository.SfaLeaveRepository;
import com.biz.crm.sfa.leave.local.service.SfaLeaveService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SfaLeaverProcessCompleteListener
implements ProcessCompleteListener {
    @Autowired
    private SfaLeaveRepository sfaLeaveRepository;
    @Autowired
    private SfaLeaveService sfaLeaveService;

    public String getBusinessCode() {
        return "sfa_leave";
    }

    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (!dto.getBusinessCode().equals("sfa_leave")) {
            return;
        }
        SfaLeaveEntity sfaLeaveEntity = (SfaLeaveEntity)((Object)this.sfaLeaveRepository.getById((Serializable)((Object)dto.getBusinessNo())));
        Validate.notNull((Object)((Object)sfaLeaveEntity), (String)"\u8bf7\u5047\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        if (LeaveTypeEnum.DAYS_OFF.getDictCode().equals(sfaLeaveEntity.getLeaveType()) && !ProcessStatusEnum.PASS.getDictCode().equals(dto.getProcessStatus())) {
            this.sfaLeaveService.updateDaysOff(sfaLeaveEntity, false);
        }
    }
}

