/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.leave.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.overtime.sdk.event.OvertimeApplyEventListener;
import com.biz.crm.sfa.business.overtime.sdk.vo.OvertimeApplyVo;
import com.biz.crm.sfa.leave.local.entity.SfaDaysOffEntity;
import com.biz.crm.sfa.leave.local.repository.SfaDaysOffRepository;
import java.math.BigDecimal;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OvertimeEventListener
implements OvertimeApplyEventListener {
    @Autowired
    private SfaDaysOffRepository sfaDaysOffRepository;
    @Autowired
    private LoginUserService loginUserService;

    public void onApproved(OvertimeApplyVo vo) {
        if (ObjectUtils.isEmpty((Object)vo) || StringUtils.isBlank((CharSequence)vo.getUserName())) {
            return;
        }
        SfaDaysOffEntity sfaDaysOffEntity = this.sfaDaysOffRepository.findByUserName(vo.getUserName());
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        if (ObjectUtils.isEmpty((Object)((Object)sfaDaysOffEntity))) {
            sfaDaysOffEntity = new SfaDaysOffEntity();
            sfaDaysOffEntity.setUserName(vo.getUserName());
            sfaDaysOffEntity.setRealName(vo.getUserRealName());
            sfaDaysOffEntity.setAllDays(vo.getApplyDuration());
            sfaDaysOffEntity.setUsedDays(BigDecimal.ZERO);
            sfaDaysOffEntity.setAvailableDays(vo.getApplyDuration());
            sfaDaysOffEntity.setHolidayDays(vo.getHolidayDays());
            sfaDaysOffEntity.setTenantCode(loginDetails.getTenantCode());
            this.sfaDaysOffRepository.save((Object)sfaDaysOffEntity);
        } else {
            sfaDaysOffEntity.setAllDays(sfaDaysOffEntity.getAllDays().add(vo.getApplyDuration()));
            sfaDaysOffEntity.setAvailableDays(sfaDaysOffEntity.getAvailableDays().add(vo.getApplyDuration()));
            sfaDaysOffEntity.setHolidayDays(sfaDaysOffEntity.getHolidayDays().add(vo.getHolidayDays()));
            this.sfaDaysOffRepository.updateById((Object)sfaDaysOffEntity);
        }
    }
}

