/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.leave.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.attendance.sdk.dto.RuleConditionDto;
import com.biz.crm.sfa.business.attendance.sdk.service.AttendanceRuleVoService;
import com.biz.crm.sfa.business.attendance.sdk.vo.AttendanceRuleVo;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveTypeEnum;
import com.biz.crm.sfa.leave.local.dto.SfaApplyTimeInfoDto;
import com.biz.crm.sfa.leave.local.dto.SfaLeaveDto;
import com.biz.crm.sfa.leave.local.entity.SfaDaysOffEntity;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;
import com.biz.crm.sfa.leave.local.repository.SfaDaysOffRepository;
import com.biz.crm.sfa.leave.local.repository.SfaLeaveAttachmentRepository;
import com.biz.crm.sfa.leave.local.repository.SfaLeaveRepository;
import com.biz.crm.sfa.leave.local.service.SfaLeaveService;
import com.biz.crm.sfa.leave.local.utils.SfaSignUtils;
import com.biz.crm.workflow.sdk.dto.OrgInfoDto;
import com.biz.crm.workflow.sdk.dto.PositionInfoDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.OrgInfoListener;
import com.biz.crm.workflow.sdk.listener.PositionInfoListener;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.OrgVo;
import com.biz.crm.workflow.sdk.vo.PositionVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.response.OrgInfoResponse;
import com.biz.crm.workflow.sdk.vo.response.PositionInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SfaLeaveServiceImpl
implements SfaLeaveService {
    private static final Logger log = LoggerFactory.getLogger(SfaLeaveServiceImpl.class);
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AttendanceRuleVoService attendanceRuleVoService;
    @Autowired
    private SfaLeaveRepository sfaLeaveRepository;
    @Autowired
    private SfaLeaveAttachmentRepository sfaLeaveAttachmentRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private SfaDaysOffRepository sfaDaysOffRepository;
    @Autowired
    private ProcessBusinessService processBusinessService;
    @Autowired
    private ProcessBusinessMappingService processBusinessMappingService;
    @Value(value="${workflow.process.key.leave}")
    private String processKey;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SfaLeaveEntity create(SfaLeaveDto sfaLeaveDto) {
        List<SfaLeaveEntity> repeatList;
        SfaLeaveEntity entity = this.validateTime(sfaLeaveDto);
        if (StringUtils.isNotEmpty((CharSequence)sfaLeaveDto.getId())) {
            SfaLeaveEntity old = (SfaLeaveEntity)((Object)this.sfaLeaveRepository.getById((Serializable)((Object)sfaLeaveDto.getId())));
            Validate.notNull((Object)((Object)old), (String)"\u7f16\u8f91\u5b9e\u4f53\u5df2\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
            businessMappingDto.setBusinessCode("sfa_leave");
            businessMappingDto.setBusinessNo(old.getId());
            ProcessBusinessMappingVo businessMappingVo = this.processBusinessMappingService.findSignalByConditions(businessMappingDto);
            if (Objects.nonNull(businessMappingVo)) {
                if (ProcessStatusEnum.REJECT.getDictCode().equals(businessMappingVo.getProcessStatus())) {
                    entity.setId(null);
                } else if (ProcessStatusEnum.RECOVER.getDictCode().equals(businessMappingVo.getProcessStatus())) {
                    entity.setId(old.getId());
                    this.sfaLeaveAttachmentRepository.deleteBySourceId(old.getId());
                } else {
                    Validate.isTrue((!ProcessStatusEnum.COMMIT.getDictCode().equals(businessMappingVo.getProcessStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u4e2d\u8bf7\u5047\u4e0d\u5141\u8bb8\u7f16\u8f91", (Object[])new Object[0]);
                }
            }
        }
        if (!CollectionUtils.isEmpty(repeatList = this.sfaLeaveRepository.findRepeatByDates(entity.getUserName(), entity.getBeginTime(), entity.getEndTime(), entity.getId()))) {
            List ids = repeatList.stream().map(UuidEntity::getId).collect(Collectors.toList());
            ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
            businessMappingDto.setBusinessCode("attendance_fill_clock_apply");
            businessMappingDto.setBusinessNos(ids);
            List businessMappingVos = this.processBusinessMappingService.findMultiByByConditions(businessMappingDto);
            HashMap processStatusMap = CollectionUtils.isEmpty((Collection)businessMappingVos) ? Maps.newHashMap() : businessMappingVos.stream().collect(Collectors.toMap(ProcessBusinessMappingVo::getBusinessNo, ProcessBusinessMappingVo::getProcessStatus, (a, b) -> b));
            repeatList = repeatList.stream().filter(sfaLeaveEntity -> {
                String processStatus = processStatusMap.getOrDefault(sfaLeaveEntity.getId(), ProcessStatusEnum.PASS.getDictCode());
                return ProcessStatusEnum.PASS.getDictCode().equals(processStatus) || ProcessStatusEnum.COMMIT.getDictCode().equals(processStatus);
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(repeatList)) {
            for (SfaLeaveEntity vo : repeatList) {
                if ("0".equals(vo.getLeaveDuration())) continue;
                SfaSignUtils.verifyDateRepeat(entity.getBeginTime(), entity.getEndTime(), vo.getBeginTime(), vo.getEndTime(), sfaLeaveDto.getTimeInfoList(), JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoDto.class));
            }
        }
        entity.setTimeInfoListJson(JSON.toJSONString(sfaLeaveDto.getTimeInfoList()));
        entity.setApplicationDate(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
        this.sfaLeaveRepository.saveOrUpdate((Object)entity);
        sfaLeaveDto.getAttachmentList().forEach(attachment -> {
            attachment.setSourceId(entity.getId());
            attachment.setApplyType("sfa_leave");
            attachment.setTenantCode(TenantUtils.getTenantCode());
        });
        this.sfaLeaveAttachmentRepository.saveBatch(sfaLeaveDto.getAttachmentList());
        if (LeaveTypeEnum.DAYS_OFF.getDictCode().equals(sfaLeaveDto.getLeaveType())) {
            this.updateDaysOff(entity, true);
        }
        sfaLeaveDto.setId(entity.getId());
        this.commitProcess(sfaLeaveDto);
        return entity;
    }

    @Override
    public BigDecimal countApplyDays(SfaLeaveDto reqVo) {
        BigDecimal countApplyDays = SfaSignUtils.countApplyDays(reqVo.getBeginTime(), reqVo.getEndTime(), reqVo.getTimeInfoList());
        reqVo.setLeaveDuration(countApplyDays.toString());
        RuleConditionDto conditionDto = new RuleConditionDto();
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setOrgCodes((List)Lists.newArrayList((Object[])new String[]{reqVo.getOrgCode()}));
        List attendanceRuleList = this.attendanceRuleVoService.findByRuleConditionDto(conditionDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)attendanceRuleList) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8003\u52e4\u89c4\u5219\uff0c\u65e0\u6cd5\u8bf7\u5047", (Object[])new Object[0]);
        AttendanceRuleVo attendanceRuleVo = (AttendanceRuleVo)attendanceRuleList.get(0);
        LocalDate date = LocalDate.parse(reqVo.getBeginTime());
        Validate.isTrue((boolean)attendanceRuleVo.getWorkingDay().contains(String.valueOf(date.getDayOfWeek().getValue())), (String)"\u5f00\u59cb\u65f6\u95f4\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5", (Object[])new Object[0]);
        LocalDate endDate = LocalDate.parse(reqVo.getEndTime());
        Validate.isTrue((boolean)attendanceRuleVo.getWorkingDay().contains(String.valueOf(endDate.getDayOfWeek().getValue())), (String)"\u7ed3\u675f\u65f6\u95f4\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5", (Object[])new Object[0]);
        List<SfaApplyTimeInfoDto> timeInfoList = SfaSignUtils.fillTimeInfoAndCheck(reqVo.getTimeInfoList(), reqVo.getBeginTime(), reqVo.getEndTime());
        for (int r = 0; r < timeInfoList.size(); ++r) {
            if (r == 0 || r == timeInfoList.size() - 1) continue;
            LocalDate nowDate = LocalDate.parse(timeInfoList.get(r).getTimeStr());
            if (attendanceRuleVo.getWorkingDay().contains(String.valueOf(nowDate.getDayOfWeek().getValue()))) continue;
            countApplyDays = countApplyDays.subtract(new BigDecimal(1));
        }
        if (LeaveTypeEnum.DAYS_OFF.getDictCode().equals(reqVo.getLeaveType())) {
            this.checkDaysOff(reqVo);
        }
        return countApplyDays;
    }

    private SfaLeaveEntity validateTime(SfaLeaveDto reqVo) {
        SfaLeaveEntity entity;
        List userVoList = this.userFeignVoService.findByUserNames((List)Lists.newArrayList((Object[])new String[]{reqVo.getUserName()}));
        Validate.notEmpty((Collection)userVoList, (String)"\u8bf7\u5047\u4eba\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        UserVo userVo = (UserVo)userVoList.stream().findFirst().get();
        reqVo.setRealName(userVo.getFullName());
        reqVo.setPosCode(userVo.getPositionCode());
        reqVo.setPosName(userVo.getPositionName());
        reqVo.setOrgCode(userVo.getOrgCode());
        reqVo.setOrgName(userVo.getOrgName());
        SerializableBiConsumer & Serializable sf = PositionInfoListener::onFindByIdsOrCodes;
        PositionInfoResponse response = (PositionInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)PositionInfoDto.builder().roleCodes((List)Lists.newArrayList((Object[])new String[]{reqVo.getPosCode()})).build(), PositionInfoListener.class, (SerializableBiConsumer)sf);
        if (ObjectUtils.isNotEmpty((Object)response) && !CollectionUtils.isEmpty((Collection)response.getPositionVos())) {
            PositionVo positionVo = (PositionVo)response.getPositionVos().get(0);
            reqVo.setParentPosCode(positionVo.getParentCode());
        }
        SerializableBiConsumer & Serializable orgConsumer = OrgInfoListener::findByOrgCodes;
        OrgInfoDto orgInfoDto = new OrgInfoDto();
        orgInfoDto.setOrgCode(userVo.getOrgCode());
        OrgInfoResponse orgResponse = (OrgInfoResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)orgInfoDto, OrgInfoListener.class, (SerializableBiConsumer)orgConsumer);
        if (ObjectUtils.isNotEmpty((Object)orgResponse) && !CollectionUtils.isEmpty((Collection)orgResponse.getOrgVos())) {
            OrgVo orgVo = (OrgVo)orgResponse.getOrgVos().get(0);
            reqVo.setParentOrgCode(orgVo.getParentCode());
            reqVo.setParentOrgName(orgVo.getParentName());
        }
        if (StringUtils.isEmpty((CharSequence)(entity = (SfaLeaveEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reqVo, SfaLeaveEntity.class, HashSet.class, ArrayList.class, new String[0]))).getLeaveType())) {
            throw new RuntimeException("\u8bf7\u5047\u7c7b\u578b\u5fc5\u4f20");
        }
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        entity.setCreateName(loginDetails.getUsername());
        entity.setCreateAccount(loginDetails.getAccount());
        entity.setCreateTime((Date)DateUtil.date());
        entity.setTenantCode(loginDetails.getTenantCode());
        if (StringUtils.isEmpty((CharSequence)entity.getUserName()) || StringUtils.isEmpty((CharSequence)entity.getRealName()) || StringUtils.isEmpty((CharSequence)entity.getPosCode()) || StringUtils.isEmpty((CharSequence)entity.getOrgCode())) {
            throw new RuntimeException("\u7533\u8bf7\u4eba\u5458\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u4fe1\u606f\uff1a\u4eba\u5458\u8d26\u53f7\u3001\u4eba\u5458\u59d3\u540d\u3001\u5c97\u4f4d\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\uff0c\u8bf7\u6838\u5bf9");
        }
        BigDecimal countApplyDays = this.countApplyDays(reqVo);
        RuleConditionDto conditionDto = new RuleConditionDto();
        conditionDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        conditionDto.setOrgCodes((List)Lists.newArrayList((Object[])new String[]{entity.getOrgCode()}));
        List attendanceRuleList = this.attendanceRuleVoService.findByRuleConditionDto(conditionDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)attendanceRuleList) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u8003\u52e4\u89c4\u5219\uff0c\u65e0\u6cd5\u8bf7\u5047", (Object[])new Object[0]);
        AttendanceRuleVo attendanceRuleVo = (AttendanceRuleVo)attendanceRuleList.get(0);
        LocalDate date = LocalDate.parse(entity.getBeginTime());
        Validate.isTrue((boolean)attendanceRuleVo.getWorkingDay().contains(String.valueOf(date.getDayOfWeek().getValue())), (String)"\u5f00\u59cb\u65f6\u95f4\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5", (Object[])new Object[0]);
        LocalDate endDate = LocalDate.parse(entity.getEndTime());
        Validate.isTrue((boolean)attendanceRuleVo.getWorkingDay().contains(String.valueOf(endDate.getDayOfWeek().getValue())), (String)"\u7ed3\u675f\u65f6\u95f4\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5", (Object[])new Object[0]);
        ArrayList<SfaApplyTimeInfoDto> nonWorkDateList = new ArrayList<SfaApplyTimeInfoDto>();
        List<SfaApplyTimeInfoDto> timeInfoList = SfaSignUtils.fillTimeInfoAndCheck(reqVo.getTimeInfoList(), entity.getBeginTime(), entity.getEndTime());
        for (int r = 0; r < timeInfoList.size(); ++r) {
            if (r == 0 || r == timeInfoList.size() - 1) continue;
            LocalDate nowDate = LocalDate.parse(timeInfoList.get(r).getTimeStr());
            if (attendanceRuleVo.getWorkingDay().contains(String.valueOf(nowDate.getDayOfWeek().getValue()))) continue;
            nonWorkDateList.add(timeInfoList.get(r));
        }
        if (nonWorkDateList.size() > 0) {
            entity.setNonWorkDateListJson(JSON.toJSONString(nonWorkDateList));
        }
        entity.setLeaveDuration(countApplyDays.toString());
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addAttachment(SfaLeaveDto dto) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u8bf7\u5047\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
        businessMappingDto.setBusinessCode("sfa_leave");
        businessMappingDto.setBusinessNo(entity.getId());
        ProcessBusinessMappingVo businessMappingVo = this.processBusinessMappingService.findSignalByConditions(businessMappingDto);
        if (Objects.nonNull(businessMappingVo)) {
            Validate.isTrue((boolean)ProcessStatusEnum.COMMIT.getDictCode().equals(businessMappingVo.getProcessStatus()), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u8bf7\u5047\u53ef\u4ee5\u8ffd\u52a0\u9644\u4ef6", (Object[])new Object[0]);
        }
        this.sfaLeaveAttachmentRepository.saveOrUpdateBatch(dto.getAttachmentList());
    }

    private void commitProcess(SfaLeaveDto dto) {
        ProcessBusinessDto processBusiness = new ProcessBusinessDto();
        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setBusinessCode("sfa_leave");
        processBusiness.setProcessKey(this.processKey);
        processBusiness.setProcessTitle("\u8bf7\u5047\u5ba1\u6279\u6d41\u7a0b");
        JSONObject extData = new JSONObject();
        extData.put("duration", (Object)dto.getLeaveDuration());
        processBusiness.setExtData(extData.toJSONString());
        this.processBusinessService.processStart(processBusiness);
    }

    private void checkDaysOff(SfaLeaveDto dto) {
        SfaDaysOffEntity sfaDaysOffEntity = this.sfaDaysOffRepository.findByUserName(dto.getUserName());
        Validate.notNull((Object)((Object)sfaDaysOffEntity), (String)"\u7528\u6237\u4e0d\u5b58\u5728\u8c03\u4f11\u5929\u6570\uff0c\u65e0\u6cd5\u8c03\u4f11", (Object[])new Object[0]);
        Validate.isTrue((sfaDaysOffEntity.getAvailableDays().compareTo(new BigDecimal(dto.getLeaveDuration())) > -1 ? 1 : 0) != 0, (String)("\u6b64\u7528\u6237\u8c03\u4f11\u4ec5" + sfaDaysOffEntity.getAvailableDays().doubleValue() + "\u5929\uff0c\u65e0\u6cd5\u8fdb\u884c\u8c03\u4f11\u7533\u8bf7"), (Object[])new Object[0]);
    }

    @Override
    public void updateDaysOff(SfaLeaveEntity entity, boolean deduction) {
        SfaDaysOffEntity sfaDaysOffEntity = this.sfaDaysOffRepository.findByUserName(entity.getUserName());
        if (deduction) {
            sfaDaysOffEntity.setAvailableDays(sfaDaysOffEntity.getAvailableDays().subtract(new BigDecimal(entity.getLeaveDuration())));
            sfaDaysOffEntity.setUsedDays(sfaDaysOffEntity.getUsedDays().add(new BigDecimal(entity.getLeaveDuration())));
        } else {
            sfaDaysOffEntity.setAvailableDays(sfaDaysOffEntity.getAvailableDays().add(new BigDecimal(entity.getLeaveDuration())));
            sfaDaysOffEntity.setUsedDays(sfaDaysOffEntity.getUsedDays().subtract(new BigDecimal(entity.getLeaveDuration())));
        }
        this.sfaDaysOffRepository.updateById((Object)sfaDaysOffEntity);
    }
}

