/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.leave.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveApplySummaryDto;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveTypeEnum;
import com.biz.crm.sfa.business.leave.sdk.event.LeaveUpperDataListener;
import com.biz.crm.sfa.business.leave.sdk.service.SfaLeaveVoService;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveApplySummaryVo;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveAttachmentVo;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import com.biz.crm.sfa.leave.local.dto.SfaLeaveDto;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveAttachmentEntity;
import com.biz.crm.sfa.leave.local.entity.SfaLeaveEntity;
import com.biz.crm.sfa.leave.local.repository.SfaLeaveAttachmentRepository;
import com.biz.crm.sfa.leave.local.repository.SfaLeaveRepository;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SfaLeaveVoServiceImpl
implements SfaLeaveVoService {
    private static final Logger log = LoggerFactory.getLogger(SfaLeaveVoServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private SfaLeaveRepository sfaLeaveRepository;
    @Autowired
    private SfaLeaveAttachmentRepository sfaLeaveAttachmentRepository;
    @Autowired
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private LeaveUpperDataListener leaveUpperDataListener;

    public Page<SfaLeaveVo> findByConditions(Pageable pageable, SfaLeaveListDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplicationDateStart())) {
            dto.setApplicationDateStart(dto.getApplicationDateStart() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getApplicationDateEnd())) {
            dto.setApplicationDateEnd(dto.getApplicationDateEnd() + " 23:59:59");
        }
        if (Objects.isNull(this.leaveUpperDataListener)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), 0L);
        }
        dto.setBusinessCode("sfa_leave");
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page entityPage = this.leaveUpperDataListener.findByConditions(pageable, dto);
        if (CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            return entityPage;
        }
        this.buildProcessInfo(entityPage.getRecords());
        if (!CollectionUtils.isEmpty((Collection)entityPage.getRecords())) {
            entityPage.getRecords().forEach(vo -> vo.setLeaveTypeName(LeaveTypeEnum.getByDictCode((String)vo.getLeaveType()).getDictCode()));
        }
        return entityPage;
    }

    public List<SfaLeaveVo> findBySfaLeaveListDto(SfaLeaveListDto sfaLeaveListDto) {
        List<SfaLeaveEntity> entities;
        if (StringUtils.isNotEmpty((CharSequence)sfaLeaveListDto.getApplicationDateStart())) {
            sfaLeaveListDto.setApplicationDateStart(sfaLeaveListDto.getApplicationDateStart() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty((CharSequence)sfaLeaveListDto.getApplicationDateEnd())) {
            sfaLeaveListDto.setApplicationDateEnd(sfaLeaveListDto.getApplicationDateEnd() + " 23:59:59");
        }
        if (CollectionUtils.isEmpty(entities = this.sfaLeaveRepository.findByConditions(sfaLeaveListDto))) {
            return Lists.newLinkedList();
        }
        List ids = entities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
        businessMappingDto.setBusinessCode("sfa_leave");
        businessMappingDto.setBusinessNos(ids);
        List businessMappingVos = this.processBusinessMappingService.findMultiByByConditions(businessMappingDto);
        HashMap processStatusMap = CollectionUtils.isEmpty((Collection)businessMappingVos) ? Maps.newHashMap() : businessMappingVos.stream().collect(Collectors.toMap(ProcessBusinessMappingVo::getBusinessNo, ProcessBusinessMappingVo::getProcessStatus, (a, b) -> b));
        entities = entities.stream().filter(entity -> {
            String processStatus = processStatusMap.getOrDefault(entity.getId(), ProcessStatusEnum.PASS.getDictCode());
            return ProcessStatusEnum.PASS.getDictCode().equals(processStatus);
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        List sfaLeaveVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, SfaLeaveEntity.class, SfaLeaveVo.class, HashSet.class, ArrayList.class, new String[0]);
        sfaLeaveVos.forEach(vo -> vo.setLeaveTypeName(LeaveTypeEnum.getByDictCode((String)vo.getLeaveType()).getDictCode()));
        return sfaLeaveVos;
    }

    public SfaLeaveVo queryById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        SfaLeaveEntity sfaLeave = (SfaLeaveEntity)((Object)this.sfaLeaveRepository.getById((Serializable)((Object)id)));
        if (Objects.isNull((Object)sfaLeave)) {
            return null;
        }
        SfaLeaveVo leaveVo = (SfaLeaveVo)this.nebulaToolkitService.copyObjectByBlankList((Object)sfaLeave, SfaLeaveVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.buildProcessInfo(Lists.newArrayList((Object[])new SfaLeaveVo[]{leaveVo}));
        List<SfaLeaveAttachmentEntity> attachmentEntities = this.sfaLeaveAttachmentRepository.findBySourceId(id);
        if (!CollectionUtils.isEmpty(attachmentEntities)) {
            leaveVo.setAttachmentList((List)this.nebulaToolkitService.copyCollectionByWhiteList(attachmentEntities, SfaLeaveAttachmentEntity.class, SfaLeaveAttachmentVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return leaveVo;
    }

    public Page<SfaLeaveApplySummaryVo> findSummaryByConditions(Pageable pageable, SfaLeaveApplySummaryDto dto) {
        if (Objects.isNull(this.leaveUpperDataListener)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), 0L);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setBusinessCode("sfa_leave");
        dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        Page voPage = this.leaveUpperDataListener.findSummaryByConditions(pageable, dto);
        List voList = voPage.getRecords();
        Page pageResult = new Page(voPage.getCurrent(), voPage.getSize(), voPage.getTotal());
        if (!CollectionUtils.isEmpty((Collection)voList)) {
            pageResult.setRecords((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)voList, SfaLeaveVo.class, SfaLeaveApplySummaryVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        Set<String> userNames = pageResult.getRecords().stream().map(SfaLeaveApplySummaryVo::getUserName).collect(Collectors.toSet());
        SfaLeaveDto sfaLeaveDto = new SfaLeaveDto();
        sfaLeaveDto.setBeginTime(dto.getLeaveDateStart());
        sfaLeaveDto.setEndTime(dto.getLeaveDateEnd());
        sfaLeaveDto.setUserNames(userNames);
        List<SfaLeaveEntity> details = this.sfaLeaveRepository.findDetails(sfaLeaveDto);
        if (CollectionUtils.isEmpty(details)) {
            return pageResult;
        }
        List ids = details.stream().map(UuidEntity::getId).collect(Collectors.toList());
        ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
        businessMappingDto.setBusinessCode("sfa_leave");
        businessMappingDto.setBusinessNos(ids);
        List businessMappingVos = this.processBusinessMappingService.findMultiByByConditions(businessMappingDto);
        HashMap processStatusMap = CollectionUtils.isEmpty((Collection)businessMappingVos) ? Maps.newHashMap() : businessMappingVos.stream().collect(Collectors.toMap(ProcessBusinessMappingVo::getBusinessNo, ProcessBusinessMappingVo::getProcessStatus, (a, b) -> b));
        details = details.stream().filter(entity -> {
            String processStatus = processStatusMap.getOrDefault(entity.getId(), ProcessStatusEnum.PASS.getDictCode());
            return ProcessStatusEnum.PASS.getDictCode().equals(processStatus);
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(details)) {
            return pageResult;
        }
        Map<String, List<SfaLeaveEntity>> userDetailMap = details.stream().collect(Collectors.groupingBy(SfaLeaveEntity::getUserName));
        pageResult.getRecords().forEach(summary -> {
            List leaveEntities = (List)userDetailMap.get(summary.getUserName());
            if (!CollectionUtils.isEmpty((Collection)leaveEntities)) {
                block9: for (SfaLeaveEntity e : leaveEntities) {
                    LeaveTypeEnum leaveTypeEnum = LeaveTypeEnum.getByDictCode((String)e.getLeaveType());
                    switch (leaveTypeEnum) {
                        case DAYS_OFF: {
                            summary.setDaysOff(summary.getDaysOff().add(new BigDecimal(e.getLeaveDuration())));
                            continue block9;
                        }
                        case ANNUAL_LEAVE: {
                            summary.setAnnualLeave(summary.getAnnualLeave().add(new BigDecimal(e.getLeaveDuration())));
                            continue block9;
                        }
                        case SICK_LEAVE: {
                            summary.setSickLeave(summary.getSickLeave().add(new BigDecimal(e.getLeaveDuration())));
                            continue block9;
                        }
                        case FUNERAL_LEAVE: {
                            summary.setFuneralLeave(summary.getFuneralLeave().add(new BigDecimal(e.getLeaveDuration())));
                            continue block9;
                        }
                        case MARRIAGE_LEAVE: {
                            summary.setMarriageLeave(summary.getMarriageLeave().add(new BigDecimal(e.getLeaveDuration())));
                            continue block9;
                        }
                        case PERSONAL_LEAVE: {
                            summary.setPersonalLeave(summary.getPersonalLeave().add(new BigDecimal(e.getLeaveDuration())));
                            continue block9;
                        }
                        case MATERNITY_LEAVE: {
                            summary.setMaternityLeave(summary.getMaternityLeave().add(new BigDecimal(e.getLeaveDuration())));
                            continue block9;
                        }
                    }
                    summary.setPaternityLeave(summary.getPaternityLeave().add(new BigDecimal(e.getLeaveDuration())));
                }
            }
        });
        return pageResult;
    }

    private void buildProcessInfo(List<SfaLeaveVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        List ids = voList.stream().map(UuidVo::getId).collect(Collectors.toList());
        ProcessBusinessMappingDto businessMappingDto = new ProcessBusinessMappingDto();
        businessMappingDto.setBusinessCode("sfa_leave");
        businessMappingDto.setBusinessNos(ids);
        List businessMappingVos = this.processBusinessMappingService.findMultiByByConditions(businessMappingDto);
        HashMap processMap = CollectionUtils.isEmpty((Collection)businessMappingVos) ? Maps.newHashMap() : businessMappingVos.stream().collect(Collectors.toMap(ProcessBusinessMappingVo::getBusinessNo, t -> (ProcessBusinessVo)this.nebulaToolkitService.copyObjectByBlankList(t, ProcessBusinessVo.class, HashSet.class, ArrayList.class, new String[0]), (a, b) -> b));
        voList.forEach(vo -> vo.setProcessBusiness((ProcessBusinessVo)processMap.get(vo.getId())));
    }
}

