package com.biz.crm.sfa.business.leave.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 请假日期枚举
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@Getter
@AllArgsConstructor
public enum LeaveDateType {

  /**
   * 年假
   */
  ALL_DAY("1", "1", "全天", "1"),
  /**
   * 事假
   */
  FORENOON("2", "2", "上午", "2"),
  /**
   * 产假
   */
  AFTERNOON("3", "3", "下午", "3"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
