package com.biz.crm.sfa.business.leave.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 请假类型枚举
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@Getter
@AllArgsConstructor
public enum LeaveTypeEnum {

  /**
   * 年假
   */
  ANNUAL_LEAVE("annual_leave", "annual_leave", "年假", "1"),
  /**
   * 事假
   */
  PERSONAL_LEAVE("personal_leave", "personal_leave", "事假", "2"),
  /**
   * 婚假
   */
  MARRIAGE_LEAVE("marriage_leave", "marriage_leave", "婚假", "3"),
  /**
   * 丧假
   */
  FUNERAL_LEAVE("funeral_leave", "funeral_leave", "丧假", "4"),
  /**
   * 陪产假
   */
  PATERNITY_LEAVE("paternity_leave", "paternity_leave", "陪产假", "5"),
  /**
   * 调休
   */
  DAYS_OFF("days_off", "days_off", "调休", "6"),
  /**
   * 病假
   */
  SICK_LEAVE("sick_leave", "sick_leave", "病假", "7"),
  /**
   * 产假
   */
  MATERNITY_LEAVE("maternity_leave", "maternity_leave", "产假", "8"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过dictCode获取 SignRuleDateKeyEnum
   *
   * @param dictCode
   * @return
   */
  public static LeaveTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(LeaveTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }
}
