package com.biz.crm.sfa.business.leave.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.sfa.business.leave.sdk.enums.LeaveTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 请假天数计算dto
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "LeaveDaysCountDto", description = "请假天数计算dto")
public class LeaveDaysCountDto extends TenantDto {

  /**
   * 请假类型
   *
   * @see LeaveTypeEnum
   */
  @ApiModelProperty(value = "请假类型")
  private String leaveType;


}
