package com.biz.crm.sfa.business.leave.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;

/**
 * 请假申请列表查询 请求vo
 *
 * @author liuhongming
 * @date 2020-11-19 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaLeaveListDto", description = "请假申请列表查询请求 ")
public class SfaLeaveListDto extends TenantFlagOpDto {

  /**
   * 关键字
   */
  @ApiModelProperty("关键字")
  private String keyWord;

  /**
   * 请假类型
   */
  @ApiModelProperty("请假类型 请假类型")
  private String leaveType;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号 人员账号")
  private String userName;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号 人员账号")
  private String realName;

  /**
   * 申请日期开始
   */
  @ApiModelProperty("申请日期开始 (yyyy-MM-dd)")
  private String applicationDateStart;

  /**
   * 申请日期结束
   */
  @ApiModelProperty("申请日期结束 (yyyy-MM-dd)")
  private String applicationDateEnd;

  /**
   * 请假开始时间开始
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @ApiModelProperty("请假开始时间开始 (yyyy-MM-dd)")
  private Date startTimeBegin;

  /**
   * 请假开始时间结束
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @ApiModelProperty("请假开始时间结束 (yyyy-MM-dd)")
  private Date startTimeEnd;

  /**
   * 请假结束时间开始
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @ApiModelProperty("请假结束时间开始 (yyyy-MM-dd)")
  private Date endTimeBegin;

  /**
   * 请假结束时间结束
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @ApiModelProperty("请假结束时间结束 (yyyy-MM-dd)")
  private Date endTimeEnd;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态 审批状态")
  private String processStatus;

  /**
   * 查询可见范围
   */
  @ApiModelProperty("查询可见范围")
  private String visibleScope;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String postCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String posName;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  @ApiModelProperty("人员账号集合")
  private Set<String> userNames;

  /**
   * 流程业务模块编码
   */
  @ApiModelProperty("流程业务模块编码")
  private String businessCode;

}