package com.biz.crm.sfa.business.leave.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 请假类型枚举
 *
 * @author ning.zhang
 * @date 2022/5/23
 */
@Getter
@AllArgsConstructor
public enum LeaveVisibleEnum {

  /**
   * 年假
   */
  all("all", "all", "全部", "1"),
  /**
   * 事假
   */
  only_me("only_me", "only_me", "只看我的", "2"),
  /**
   * 婚假
   */
  my_children("my_children", "my_children", "我的下属", "3");
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  /**
   * 通过dictCode获取 SignRuleDateKeyEnum
   *
   * @param dictCode
   * @return
   */
  public static LeaveVisibleEnum getByDictCode(String dictCode) {
    return Arrays.stream(LeaveVisibleEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }
}
