package com.biz.crm.sfa.business.leave.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 考勤规则key枚举
 * @author jerry7
 */
public enum SignRuleDateKeyEnum {
  SIGN_RULE_INDATE("sign_rule_indate","sign_rule_indate", "考勤有效期规则key","1"),
  OVERTIME_INDATE("overtime_indate","overtime_indate", "加班调休有效期key","2"),
  LEAVE_INDATE("leave_indate","leave_indate", "请假对冲有效期key","3");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  SignRuleDateKeyEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 SignRuleDateKeyEnum
   *
   * @param key
   * @return
   */
  public static SignRuleDateKeyEnum getByKey(String key) {
    return Arrays.stream(SignRuleDateKeyEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 SignRuleDateKeyEnum
   *
   * @param dictCode
   * @return
   */
  public static SignRuleDateKeyEnum getByDictCode(String dictCode) {
    return Arrays.stream(SignRuleDateKeyEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }
}
