package com.biz.crm.sfa.business.leave.sdk.event;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveApplySummaryDto;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import org.springframework.data.domain.Pageable;

/**
 * 请假上层数据获取监听器
 * 本服务无法实现的数据关联查询,可以通过该接口向上层发送数据请求来实现数据的封装
 *
 * @author ning.zhang
 * @date 2022/9/2
 */
public interface LeaveUpperDataListener {

  /**
   * 根据参数分页查询我的我的申请列表
   *
   * @param pageable        分页参数
   * @param sfaLeaveListDto 查询参数
   * @return 请假分页数据
   */
  Page<SfaLeaveVo> findByConditions(Pageable pageable, SfaLeaveListDto sfaLeaveListDto);


  /**
   * 根据参数分页查询我的我的申请列表
   *
   * @param pageable 分页参数
   * @param dto      查询参数
   * @return 请假分页数据
   */
  Page<SfaLeaveVo> findSummaryByConditions(Pageable pageable, SfaLeaveApplySummaryDto dto);

}
