package com.biz.crm.sfa.business.leave.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveApplySummaryDto;
import com.biz.crm.sfa.business.leave.sdk.dto.SfaLeaveListDto;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveApplySummaryVo;
import com.biz.crm.sfa.business.leave.sdk.vo.SfaLeaveVo;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 请假接口
 */
public interface SfaLeaveVoService {

  /**
   * 根据参数分页查询我的我的申请列表
   *
   * @param pageable        分页参数
   * @param sfaLeaveListDto 查询参数
   * @return 请假分页数据
   */
  Page<SfaLeaveVo> findByConditions(Pageable pageable, SfaLeaveListDto sfaLeaveListDto);


  /**
   * 查询用户请假数据
   *
   * @param sfaLeaveListDto 查询参数
   * @return 请假数据
   */
  List<SfaLeaveVo> findBySfaLeaveListDto(SfaLeaveListDto sfaLeaveListDto);

  /**
   * 根据审核任务id查询
   *
   * @param id id
   * @return SfaLeaveVo
   */
  SfaLeaveVo queryById(String id);

  /**
   * 根据参数分页查询我的我的申请列表
   *
   * @param pageable 分页参数
   * @param dto      查询参数
   * @return 请假分页数据
   */
  Page<SfaLeaveApplySummaryVo> findSummaryByConditions(Pageable pageable, SfaLeaveApplySummaryDto dto);
}

