package com.biz.crm.sfa.business.notice.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import com.biz.crm.sfa.business.notice.local.service.NoticeCommentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 公告评论表(NoticeComment)表相关的http接口
 *
 * @author songjingen
 * @since 2022-05-27 15:16:49
 */
@RestController
@RequestMapping("/v1/notice/noticeComment")
@Slf4j
@Api(tags = "公告管理：NoticeComment：公告评论表")
public class NoticeCommentController {
  /**
   * 服务对象
   */
  @Autowired
  private NoticeCommentService noticeCommentService;

  /**
   * 新增数据
   *
   * @param noticeComment 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "移动端-新增数据")
  @PostMapping
  public Result<NoticeComment> create(@ApiParam(name = "noticeComment", value = "公告评论表") @RequestBody NoticeComment noticeComment) {
    try {
      NoticeComment result = this.noticeCommentService.create(noticeComment);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更改可见状态
   *
   * @param ids
   * @return 新增结果
   * @
   */
  @ApiOperation(value = "更改可见状态")
  @PostMapping("updateVisibleStateByIds")
  public Result<?> updateVisibleStateByIds(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.noticeCommentService.updateVisibleStateByIds(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
