package com.biz.crm.sfa.business.notice.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.notice.local.entity.NoticeCommentLikeRecord;
import com.biz.crm.sfa.business.notice.local.service.NoticeCommentLikeRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 评论点赞记录表(NoticeCommentLikeRecord)表相关的http接口
 *
 * @author songjingen
 * @since 2022-06-01 10:22:49
 */
@RestController
@RequestMapping("/v1/notice/noticeCommentLikeRecord")
@Slf4j
@Api(tags = "公告管理：NoticeCommentLikeRecord：评论点赞记录表")
public class NoticeCommentLikeRecordController {
  /**
   * 服务对象
   */
  @Autowired
  private NoticeCommentLikeRecordService noticeCommentLikeRecordService;

  /**
   * 移动端-根据当前用户点赞
   *
   * @param commentId 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "移动端-根据当前用户点赞")
  @PostMapping("createByCommentIdAndCurrentUser")
  public Result<NoticeCommentLikeRecord> createByCommentIdAndCurrentUser(@ApiParam(name = "commentId", value = "评论id") @RequestBody String commentId) {
    try {
      NoticeCommentLikeRecord result = this.noticeCommentLikeRecordService.createByCommentIdAndCurrentUser(commentId);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 移动端-根据当前用户取消点赞
   *
   * @return 删除结果
   */
  @DeleteMapping("deleteByCurrentUserAndCommentId")
  @ApiOperation(value = "移动端-根据当前用户取消点赞")
  public Result<?> deleteByCurrentUserAndCommentId(@ApiParam(name = "commentId", value = "评论id") @RequestBody String commentId) {
    try {
      this.noticeCommentLikeRecordService.deleteByCurrentUser(commentId);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
