package com.biz.crm.sfa.business.notice.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.notice.sdk.service.NoticeCommentVoService;
import com.biz.crm.sfa.business.notice.sdk.vo.NoticeCommentVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公告评论表(NoticeCommentVo)表相关的http接口
 *
 * @author songjingen
 * @since 2022-05-27 15:16:49
 */
@RestController
@RequestMapping("/v1/notice/noticeCommentVo")
@Slf4j
@Api(tags = "公告管理：NoticeCommentVo：公告评论vo")
public class NoticeCommentVoController {
  /**
   * 服务对象
   */
  @Autowired
  private NoticeCommentVoService noticeCommentVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param noticeId 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findPageByNoticeId")
  public Result<Page<NoticeCommentVo>> findPageByNoticeId(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "noticeId", value = "公告id") String noticeId) {
    try {
      Page<NoticeCommentVo> page = this.noticeCommentVoService.findPageByNoticeId(pageable, noticeId);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
