package com.biz.crm.sfa.business.notice.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;


/**
 * 公告实体类
 *
 * @author songjingen
 * @date 2022/5/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "Notice", description = "公告实体类")
@Entity
@TableName("sfa_notice")
@Table(name = "sfa_notice", indexes = {
    @Index(name = "sfa_notice_index1", columnList = "title"),
    @Index(name = "sfa_notice_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_notice", comment = "公告表")
public class Notice extends TenantFlagOpEntity {

  private static final long serialVersionUID = 9014755486223607858L;

  /**
   * 标题
   */
  @ApiModelProperty("标题")
  @Column(name = "title", length = 128, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '标题'")
  private String title;

  /**
   * 类型
   */
  @ApiModelProperty("类型")
  @Column(name = "notice_type", length = 10, nullable = false, columnDefinition = "VARCHAR(10) COMMENT '类型'")
  private String noticeType;

  /**
   * 是否置顶
   */
  @ApiModelProperty("是否置顶: true-是，false-否")
  @Column(name = "notice_top", nullable = false, columnDefinition = "bit(1) COMMENT '是否置顶: 1-是，0-否'")
  private Boolean noticeTop;

  /**
   * 是否发布
   */
  @ApiModelProperty("是否发布: true-是，false-否")
  @Column(name = "publish", nullable = false, columnDefinition = "bit(1) COMMENT '是否发布: 1-是，0-否'")
  private Boolean publish;

  /**
   * 是否允许评论
   */
  @ApiModelProperty("是否允许评论: true-是，false-否")
  @Column(name = "allow_comment", nullable = false, columnDefinition = "bit(1) COMMENT '是否允许评论: 1-是，0-否'")
  private Boolean allowComment = false;

  /**
   * 发布部门code
   */
  @ApiModelProperty("发布部门code")
  @Column(name = "publish_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '发布部门code'")
  private String publishOrgCode;

  /**
   * 发布部门名称
   */
  @ApiModelProperty("发布部门名称")
  @Column(name = "publish_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '发布部门名称'")
  private String publishOrgName;

  /**
   * 生效开始时间
   */
  @ApiModelProperty("生效开始时间")
  @Column(name = "start_time", columnDefinition = "datetime COMMENT '生效开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date startTime;


  /**
   * 生效结束时间
   */
  @ApiModelProperty("生效结束时间")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT '生效结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date endTime;

  /**
   * 公告内容
   */
  @ApiModelProperty("公告内容")
  @Column(name = "content", columnDefinition = "text COMMENT '公告内容'")
  private String content;

  /**
   * 公告文件关联信息
   */
  @ApiModelProperty("公告文件关联信息")
  @Transient
  @TableField(exist = false)
  private List<NoticeFile> fileList;

  /**
   * 公告范围关联信息
   */
  @ApiModelProperty("公告范围关联信息")
  @Transient
  @TableField(exist = false)
  private List<NoticeScope> scopeList;
}
