package com.biz.crm.sfa.business.notice.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * 公告评论实体
 *
 * @author songjingen
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeComment", description = "公告评论实体")
@Entity
@TableName("sfa_notice_comment")
@Table(name = "sfa_notice_comment", indexes = {
    @Index(name = "sfa_notice_comment_index1", columnList = "notice_id"),
    @Index(name = "sfa_notice_comment_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_notice_comment", comment = "公告评论表")
public class NoticeComment extends TenantEntity {


  private static final long serialVersionUID = 9014755486223607858L;
  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  @Column(name = "notice_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '公告id'")
  private String noticeId;

  /**
   * 评论人员账号
   */
  @ApiModelProperty("评论人员账号")
  @Column(name = "user_name", nullable = false, columnDefinition = "VARCHAR(64) COMMENT '评论人员账号'")
  private String userName;

  /**
   * 评论内容
   */
  @ApiModelProperty("评论内容")
  @Column(name = "content", columnDefinition = "text COMMENT '评论内容'")
  private String content;

  /**
   * 是否可见
   */
  @ApiModelProperty("是否可见")
  @Column(name = "visible_state", columnDefinition = "bit(1) COMMENT '是否可见: 1-是，0-否'")
  private Boolean visibleState;


}
