package com.biz.crm.sfa.business.notice.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 公告文件实体类
 *
 * @author songjingen
 * @date 2022/5/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeFile", description = "公告文件实体类")
@Entity
@TableName("sfa_notice_file")
@Table(name = "sfa_notice_file", indexes = {
    @Index(name = "sfa_notice_file_index1", columnList = "notice_id"),
    @Index(name = "sfa_notice_file_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_notice_file", comment = "公告文件表")
public class NoticeFile extends FileEntity {

  private static final long serialVersionUID = 5636349164148962136L;
  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  @Column(name = "notice_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '公告id'")
  private String noticeId;

  /**
   * 文件路径
   */
  @ApiModelProperty("文件路径")
  @Column(name = "file_url", nullable = false, columnDefinition = "VARCHAR(255) COMMENT '文件路径'")
  private String fileUrl;

}
