package com.biz.crm.sfa.business.notice.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * 公告阅读记录实体类
 *
 * @author 宋金根
 * @date 2022/5/27
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeReadRecord", description = "公告阅读记录实体类")
@Entity
@TableName("sfa_notice_read_record")
@Table(name = "sfa_notice_read_record", indexes = {
    @Index(name = "sfa_notice_read_record_index1", columnList = "notice_id,user_name", unique = true),
    @Index(name = "sfa_notice_read_record_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_notice_read_record", comment = "公告阅读记录表")
public class NoticeReadRecord extends TenantOpEntity {


  private static final long serialVersionUID = 7343455128330164869L;
  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  @Column(name = "notice_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '公告id'")
  private String noticeId;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  @Column(name = "user_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '用户账号'")
  private String userName;
}
