package com.biz.crm.sfa.business.notice.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.sdk.dto.NoticePageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 公告表(Notice)表mybatis访问层
 *
 * @author songjingen
 * @since 2022-05-27 14:17:38
 */
public interface NoticeMapper extends BaseMapper<Notice> {

  /**
   * 分页查询所有数据
   *
   * @param page   分页对象
   * @param notice 查询实体
   * @return 所有数据
   */
  public Page<Notice> findByConditions(@Param("page") Page<Notice> page, @Param("dto") NoticePageDto notice);

  /**
   * 查询公告详情，包含关联表信息
   *
   * @param id
   * @return
   */
  Notice findDetailsById(@Param("id") String id);
}

