package com.biz.crm.sfa.business.notice.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.notice.local.entity.NoticeCommentLikeRecord;
import com.biz.crm.sfa.business.notice.local.mapper.NoticeCommentLikeRecordMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 评论点赞记录表(NoticeCommentLikeRecord)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-01 10:22:49
 */
@Component
public class NoticeCommentLikeRecordRepository extends ServiceImpl<NoticeCommentLikeRecordMapper, NoticeCommentLikeRecord> {

  @Autowired
  private NoticeCommentLikeRecordMapper noticeCommentLikeRecordMapper;

  /**
   * 分页查询数据
   *
   * @param pageable                分页对象
   * @param noticeCommentLikeRecord 实体对象
   * @return
   */
  public Page<NoticeCommentLikeRecord> findByConditions(Pageable pageable, NoticeCommentLikeRecord noticeCommentLikeRecord) {
    Page<NoticeCommentLikeRecord> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<NoticeCommentLikeRecord> pageList = this.noticeCommentLikeRecordMapper.findByConditions(page, noticeCommentLikeRecord);
    return pageList;
  }

  /**
   * 根据用户账号删除数据
   *
   * @param userName
   */
  public void deleteByUserName(String userName) {
    this.lambdaUpdate().eq(NoticeCommentLikeRecord::getUserName, userName)
        .eq(NoticeCommentLikeRecord::getTenantCode, TenantUtils.getTenantCode())
        .remove();
  }

  /**
   * 根据评论id集合查询数据
   *
   * @param commentIds
   * @return
   */
  public List<NoticeCommentLikeRecord> findByCommentIds(List<String> commentIds) {
    return this.lambdaQuery()
        .eq(NoticeCommentLikeRecord::getTenantCode, TenantUtils.getTenantCode())
        .in(NoticeCommentLikeRecord::getCommentId, commentIds)
        .list();
  }

  /**
   * 根据用户账号和评论id查询对象
   *
   * @param userName
   * @param commentId
   * @return
   */
  public NoticeCommentLikeRecord findByUserNameAndCommentId(String userName, String commentId) {
    return this.lambdaQuery()
        .eq(NoticeCommentLikeRecord::getUserName, userName)
        .eq(NoticeCommentLikeRecord::getCommentId, commentId)
        .eq(NoticeCommentLikeRecord::getTenantCode, TenantUtils.getTenantCode())
        .one();
  }
}

