package com.biz.crm.sfa.business.notice.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.notice.local.entity.NoticeFile;
import com.biz.crm.sfa.business.notice.local.mapper.NoticeFileMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公告文件表(NoticeFile)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-27 14:17:59
 */
@Component
public class NoticeFileRepository extends ServiceImpl<NoticeFileMapper, NoticeFile> {

  @Autowired
  private NoticeFileMapper noticeFileMapper;

  /**
   * 分页查询数据
   *
   * @param pageable   分页对象
   * @param noticeFile 实体对象
   * @return
   */
  public Page<NoticeFile> findByConditions(Pageable pageable, NoticeFile noticeFile) {
    Page<NoticeFile> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<NoticeFile> pageList = this.noticeFileMapper.findByConditions(page, noticeFile);
    return pageList;
  }


  /**
   * 根据noticeId集合删除数据
   *
   * @param noticeIds
   */
  public void deleteByNoticeIds(List<String> noticeIds) {
    this.lambdaUpdate().in(NoticeFile::getNoticeId, noticeIds).remove();
  }
}

