package com.biz.crm.sfa.business.notice.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.local.mapper.NoticeMapper;
import com.biz.crm.sfa.business.notice.sdk.dto.NoticePageDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公告表(Notice)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-27 14:17:38
 */
@Component
public class NoticeRepository extends ServiceImpl<NoticeMapper, Notice> {

  @Autowired
  private NoticeMapper noticeMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param notice   实体对象
   * @return
   */
  public Page<Notice> findByConditions(Pageable pageable, NoticePageDto notice) {
    Page<Notice> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<Notice> pageList = this.noticeMapper.findByConditions(page, notice);
    return pageList;
  }

  /**
   * 分页查询数据
   *
   * @param notice 实体对象
   * @return
   */
  public Page<Notice> findByConditions(Page<Notice> page, NoticePageDto notice) {
    Page<Notice> pageList = this.noticeMapper.findByConditions(page, notice);
    return pageList;
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids          分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(Notice::getId, ids)
        .set(Notice::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 根据id查询详情包含关联表
   *
   * @param id id数据
   * @return
   */
  public Notice findDetailsById(String id) {
    return this.noticeMapper.findDetailsById(id);
  }

  /**
   * 批量删除数据
   *
   * @param idList
   * @param delFlagStatusEnum
   */
  public void updateDelFlagByIds(List<String> idList, DelFlagStatusEnum delFlagStatusEnum) {
    this.lambdaUpdate()
        .set(Notice::getDelFlag, delFlagStatusEnum.getCode())
        .in(Notice::getId, idList)
        .update();
  }

  /**
   * 根据id集合查询数据
   *
   * @param ids
   * @return
   */
  public List<Notice> findByIds(List<String> ids) {
    return this.lambdaQuery().in(Notice::getId, ids).list();
  }
}

