package com.biz.crm.sfa.business.notice.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.notice.local.entity.NoticeScope;
import com.biz.crm.sfa.business.notice.local.mapper.NoticeScopeMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公告范围表(NoticeScope)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-27 14:17:59
 */
@Component
public class NoticeScopeRepository extends ServiceImpl<NoticeScopeMapper, NoticeScope> {

  @Autowired
  private NoticeScopeMapper noticeScopeMapper;

  /**
   * 分页查询数据
   *
   * @param pageable    分页对象
   * @param noticeScope 实体对象
   * @return
   */
  public Page<NoticeScope> findByConditions(Pageable pageable, NoticeScope noticeScope) {
    Page<NoticeScope> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<NoticeScope> pageList = this.noticeScopeMapper.findByConditions(page, noticeScope);
    return pageList;
  }

  /**
   * 根据noticeId集合删除数据
   *
   * @param noticeIds
   */
  public void deleteByNoticeIds(List<String> noticeIds) {
    this.lambdaUpdate().in(NoticeScope::getNoticeId, noticeIds).remove();
  }
}

