package com.biz.crm.sfa.business.notice.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.notice.local.entity.NoticeComment;
import com.biz.crm.sfa.business.notice.local.entity.NoticeCommentLikeRecord;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentLikeRecordRepository;
import com.biz.crm.sfa.business.notice.local.repository.NoticeCommentRepository;
import com.biz.crm.sfa.business.notice.sdk.service.NoticeCommentVoService;
import com.biz.crm.sfa.business.notice.sdk.vo.NoticeCommentVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公告评论voService实现类
 *
 * @author songjingen
 */
@Service
public class NoticeCommentVoServiceImpl implements NoticeCommentVoService {

  @Autowired
  private NoticeCommentRepository noticeCommentRepository;

  @Autowired
  private UserFeignVoService userFeignVoService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private NoticeCommentLikeRecordRepository noticeCommentLikeRecordRepository;

  @Autowired
  private LoginUserService loginUserService;

  @Override
  public Page<NoticeCommentVo> findPageByNoticeId(Pageable pageable, String noticeId) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (StringUtils.isBlank(noticeId)) {
      return new Page<>();
    }
    Page<NoticeComment> page = this.noticeCommentRepository.findPageByNoticeId(pageable, noticeId);
    List<NoticeComment> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    Page<NoticeCommentVo> voPage = new Page<>();
    BeanUtils.copyProperties(page, voPage);
    voPage.setRecords(this.convertToNoticeCommentVo(records));
    return voPage;
  }

  /**
   * 组装vo数据
   *
   * @param records
   * @return
   */
  private List<NoticeCommentVo> convertToNoticeCommentVo(List<NoticeComment> records) {
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    String account = loginDetails.getAccount();
    List<String> userNames = records.stream().map(NoticeComment::getUserName).collect(Collectors.toList());
    List<String> commentIds = records.stream().map(NoticeComment::getId).collect(Collectors.toList());
    List<UserVo> byUserNames = this.userFeignVoService.findByUserNames(userNames);
    List<NoticeCommentLikeRecord> commentLikeRecords = this.noticeCommentLikeRecordRepository.findByCommentIds(commentIds);
    //用户分组map
    Map<String, UserVo> userMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(byUserNames)) {
      userMap = byUserNames.stream().collect(Collectors.toMap(UserVo::getUserName, o -> o));
    }
    //点赞数量分组map
    Map<String, Long> likeMap = new HashMap<>();
    Map<String, List<String>> userNameLikeMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(commentLikeRecords)) {
      likeMap = commentLikeRecords.stream().collect(Collectors.groupingBy(NoticeCommentLikeRecord::getCommentId, Collectors.counting()));
      userNameLikeMap = commentLikeRecords.stream().collect(Collectors.groupingBy(NoticeCommentLikeRecord::getCommentId, Collectors.mapping(NoticeCommentLikeRecord::getUserName, Collectors.toList())));
    }
    ArrayList<NoticeCommentVo> noticeCommentVos = new ArrayList<>();
    for (NoticeComment noticeComment : records) {
      NoticeCommentVo noticeCommentVo = this.nebulaToolkitService.copyObjectByWhiteList(noticeComment, NoticeCommentVo.class, HashSet.class, ArrayList.class);
      //赋值用户信息
      UserVo userVo = userMap.get(noticeCommentVo.getUserName());
      if (userVo != null) {
        BeanUtils.copyProperties(userVo, noticeCommentVo, "id", "tenantCode");
      }
      //赋值点赞数量
      Long count = likeMap.get(noticeComment.getId());
      if (count != null) {
        noticeCommentVo.setLikeCount(count.intValue());
      }
      //赋值当前用户是否点赞
      List<String> userNameLikes = userNameLikeMap.get(noticeComment.getId());
      if (!CollectionUtils.isEmpty(userNameLikes) && userNameLikes.contains(account)) {
        noticeCommentVo.setCurrentLikeStatus(true);
      } else {
        noticeCommentVo.setCurrentLikeStatus(false);
      }
      noticeCommentVos.add(noticeCommentVo);
    }
    return noticeCommentVos;
  }
}
