package com.biz.crm.sfa.business.notice.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.local.repository.NoticeRepository;
import com.biz.crm.sfa.business.notice.sdk.constant.NoticeConstant;
import com.biz.crm.sfa.business.notice.sdk.dto.NoticePageDto;
import com.biz.crm.sfa.business.notice.sdk.service.NoticeVoService;
import com.biz.crm.sfa.business.notice.sdk.vo.NoticeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * 公告表(NoticeVo)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-27 14:17:38
 */
@Service("noticeVoService")
public class NoticeVoServiceImpl implements NoticeVoService {

  @Autowired
  private NoticeRepository noticeRepository;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private LoginUserService loginUserService;


  @Override
  public Page<NoticeVo> findByConditions(Pageable pageable, NoticePageDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new NoticePageDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<Notice> page = this.noticeRepository.findByConditions(pageable, dto);
    List<Notice> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    List<NoticeVo> noticeVos = (List<NoticeVo>) this.nebulaToolkitService.copyCollectionByWhiteList(records, Notice.class, NoticeVo.class, HashSet.class, ArrayList.class, "fileList", "scopeList");
    Page<NoticeVo> voPage = new Page<>();
    BeanUtils.copyProperties(page, voPage);
    voPage.setRecords(noticeVos);
    return voPage;
  }

  @Override
  public NoticeVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    Notice detailsById = this.noticeRepository.findDetailsById(id);
    if (detailsById == null) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(detailsById, NoticeVo.class, HashSet.class, ArrayList.class, "fileList", "scopeList");

  }

  @Override
  public NoticeVo findLatestByCurrentUser() {
    NoticePageDto dto = this.getCurrentUserDto();
    Page<Notice> page = new Page<>(0, 1);
    Page<Notice> conditions = this.noticeRepository.findByConditions(page, dto);
    List<Notice> records = conditions.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return null;
    }
    //取最新的一条数据
    return this.nebulaToolkitService.copyObjectByWhiteList(records.get(0), NoticeVo.class, HashSet.class, ArrayList.class, "fileList", "scopeList");
  }


  @Override
  public NoticeVo findByIdAndTurnFlag(String turnFlag, String id) {
    if (StringUtils.isAnyBlank(turnFlag, id)) {
      return null;
    }
    //根据id查询当前数据,如果未查到当前数据则返回null
    Notice notice = this.noticeRepository.getById(id);
    if (notice == null) {
      return null;
    }
    NoticePageDto dto = this.getCurrentUserDto();
    dto.setTurnFlag(turnFlag);
    //设置上一页和下一页的时间
    Date createTime = notice.getCreateTime();
    if (NoticeConstant.UP.equals(turnFlag)) {
      dto.setCreateTimeEnd(createTime);
    } else if (NoticeConstant.DOWN.equals(turnFlag)) {
      dto.setCreateTimeStart(createTime);
    } else {
      return null;
    }
    //按照条件时间倒叙查询数据
    Page<Notice> page = new Page<>(0, 1);
    Page<Notice> conditions = this.noticeRepository.findByConditions(page, dto);
    List<Notice> records = conditions.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(records.get(0), NoticeVo.class, HashSet.class, ArrayList.class, "fileList", "scopeList");
  }

  /**
   * 获取当前用户分页dto
   *
   * @return
   */
  private NoticePageDto getCurrentUserDto() {
    NoticePageDto dto = new NoticePageDto();
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    List<String> roles = loginDetails.getRoles();
    if (!CollectionUtils.isEmpty(roles) && !roles.contains(CommonConstant.DEFAULT_ROLE_ADMIN)) {
      dto.setQueryFlag(CommonConstant.QUERY_FLAG_H5);
      dto.setPublish(true);
      dto.setOrgCode(loginDetails.getOrgCode());
      dto.setRoles(roles);
      dto.setNowDate(new Date());
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }
}

