/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.notice.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.notice.local.entity.Notice;
import com.biz.crm.sfa.business.notice.local.mapper.NoticeMapper;
import com.biz.crm.sfa.business.notice.sdk.dto.NoticePageDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class NoticeRepository
extends ServiceImpl<NoticeMapper, Notice> {
    @Autowired
    private NoticeMapper noticeMapper;

    public Page<Notice> findByConditions(Pageable pageable, NoticePageDto notice) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<Notice> pageList = this.noticeMapper.findByConditions((Page<Notice>)page, notice);
        return pageList;
    }

    public Page<Notice> findByConditions(Page<Notice> page, NoticePageDto notice) {
        Page<Notice> pageList = this.noticeMapper.findByConditions(page, notice);
        return pageList;
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public Notice findDetailsById(String id) {
        return this.noticeMapper.findDetailsById(id);
    }

    public void updateDelFlagByIds(List<String> idList, DelFlagStatusEnum delFlagStatusEnum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)delFlagStatusEnum.getCode())).in(UuidEntity::getId, idList)).update();
    }

    public List<Notice> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }
}

